/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.wiki.social;

import com.liferay.portal.NoSuchModelException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.social.model.BaseSocialActivityInterpreter;
import com.liferay.portlet.social.model.SocialActivity;
import com.liferay.portlet.wiki.model.WikiPage;
import com.liferay.portlet.wiki.model.WikiPageResource;
import com.liferay.portlet.wiki.service.WikiPageLocalServiceUtil;
import com.liferay.portlet.wiki.service.WikiPageResourceLocalServiceUtil;
import com.liferay.portlet.wiki.service.permission.WikiPagePermission;

public class WikiActivityInterpreter
extends BaseSocialActivityInterpreter {
    private static final String[] _CLASS_NAMES = new String[]{WikiPage.class.getName()};

    public String[] getClassNames() {
        return _CLASS_NAMES;
    }

    protected String getAttachmentTitle(SocialActivity activity, WikiPageResource pageResource, ServiceContext serviceContext) throws Exception {
        int activityType = activity.getType();
        if (activityType == 10006 || activityType == 10009 || activityType == 10010) {
            String link = null;
            FileEntry fileEntry = null;
            try {
                long fileEntryId = GetterUtil.getLong((String)activity.getExtraDataValue("fileEntryId"));
                fileEntry = PortletFileRepositoryUtil.getPortletFileEntry((long)fileEntryId);
            }
            catch (NoSuchModelException noSuchModelException) {}
            String fileEntryTitle = activity.getExtraDataValue("fileEntryTitle");
            if (fileEntry != null && !fileEntry.isInTrash()) {
                StringBundler sb = new StringBundler(9);
                sb.append(serviceContext.getPathMain());
                sb.append("/wiki/get_page_attachment?p_l_id=");
                sb.append(serviceContext.getPlid());
                sb.append("&nodeId=");
                sb.append(pageResource.getNodeId());
                sb.append("&title=");
                sb.append(HttpUtil.encodeURL((String)pageResource.getTitle()));
                sb.append("&fileName=");
                sb.append(fileEntryTitle);
                link = sb.toString();
            }
            return this.wrapLink(link, fileEntryTitle);
        }
        return "";
    }

    protected String getPath(SocialActivity activity, ServiceContext serviceContext) {
        return "/wiki/find_page?pageResourcePrimKey=" + activity.getClassPK();
    }

    protected Object[] getTitleArguments(String groupName, SocialActivity activity, String link, String title, ServiceContext serviceContext) throws Exception {
        WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.fetchWikiPageResource((long)activity.getClassPK());
        if (pageResource == null) {
            return null;
        }
        String creatorUserName = this.getUserName(activity.getUserId(), serviceContext);
        title = this.wrapLink(link, title);
        return new Object[]{groupName, creatorUserName, title, this.getAttachmentTitle(activity, pageResource, serviceContext)};
    }

    protected String getTitlePattern(String groupName, SocialActivity activity) {
        int activityType = activity.getType();
        if (activityType == 3 || activityType == 10005) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-add-comment";
            }
            return "activity-wiki-page-add-comment-in";
        }
        if (activityType == 1) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-add-page";
            }
            return "activity-wiki-page-add-page-in";
        }
        if (activityType == 10006) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-add-attachment";
            }
            return "activity-wiki-page-add-attachment-in";
        }
        if (activityType == 10009) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-remove-attachment";
            }
            return "activity-wiki-page-remove-attachment-in";
        }
        if (activityType == 10010) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-restore-attachment";
            }
            return "activity-wiki-page-restore-attachment-in";
        }
        if (activityType == 10007) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-move-to-trash";
            }
            return "activity-wiki-page-move-to-trash-in";
        }
        if (activityType == 10008) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-restore-from-trash";
            }
            return "activity-wiki-page-restore-from-trash-in";
        }
        if (activityType == 2) {
            if (Validator.isNull((String)groupName)) {
                return "activity-wiki-page-update-page";
            }
            return "activity-wiki-page-update-page-in";
        }
        return null;
    }

    protected boolean hasPermissions(PermissionChecker permissionChecker, SocialActivity activity, String actionId, ServiceContext serviceContext) throws Exception {
        if (!WikiPagePermission.contains(permissionChecker, activity.getClassPK(), "VIEW")) {
            return false;
        }
        int activityType = activity.getType();
        if (activityType == 2) {
            WikiPageResource pageResource = WikiPageResourceLocalServiceUtil.getPageResource((long)activity.getClassPK());
            double version = GetterUtil.getDouble((String)activity.getExtraDataValue("version"));
            WikiPage page = WikiPageLocalServiceUtil.getPage((long)pageResource.getNodeId(), (String)pageResource.getTitle(), (double)version);
            if (!page.isApproved() && !WikiPagePermission.contains(permissionChecker, activity.getClassPK(), "UPDATE")) {
                return false;
            }
        }
        return true;
    }
}

