/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.dynamicdatamapping.storage;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.storage.BaseFieldRenderer;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;

public class StringFieldRenderer
extends BaseFieldRenderer {
    protected String doRender(Field field, Locale locale) throws Exception {
        String fieldType = this.getFieldType(field);
        ArrayList<String> values = new ArrayList<String>();
        for (Serializable value : field.getValues(locale)) {
            String valueString = String.valueOf(value);
            if (Validator.isNull((String)valueString)) continue;
            if (fieldType.equals("radio") || fieldType.equals("select")) {
                valueString = this.handleJSON(field, valueString, locale);
            }
            values.add(valueString);
        }
        return StringUtil.merge(values, (String)", ");
    }

    protected String doRender(Field field, Locale locale, int valueIndex) throws Exception {
        Serializable value = field.getValue(locale, valueIndex);
        if (Validator.isNull((Object)value)) {
            return "";
        }
        String fieldType = this.getFieldType(field);
        if (fieldType.equals("radio") || fieldType.equals("select")) {
            return this.handleJSON(field, String.valueOf(value), locale);
        }
        return String.valueOf(value);
    }

    protected String getFieldType(Field field) throws Exception {
        DDMStructure ddmStructure = field.getDDMStructure();
        return ddmStructure.getFieldType(field.getName());
    }

    protected String handleJSON(Field field, String json, Locale locale) throws Exception {
        JSONArray jsonArray = JSONFactoryUtil.createJSONArray((String)json);
        DDMStructure ddmStructure = field.getDDMStructure();
        StringBundler sb = new StringBundler(jsonArray.length() * 2);
        int i2 = 0;
        while (i2 < jsonArray.length()) {
            Map fieldsMap = ddmStructure.getFields(field.getName(), "value", jsonArray.getString(i2), LocaleUtil.toLanguageId((Locale)locale));
            if (fieldsMap != null) {
                sb.append((String)fieldsMap.get("label"));
                if (i2 + 1 < jsonArray.length()) {
                    sb.append(", ");
                }
            }
            ++i2;
        }
        return sb.toString();
    }
}

