/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.PortletDataException;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portlet.documentlibrary.model.DLFileEntryType;
import com.liferay.portlet.documentlibrary.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.portlet.documentlibrary.util.DLUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLFileEntryTypeStagedModelDataHandler
extends BaseStagedModelDataHandler<DLFileEntryType> {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntryType.class.getName()};

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryTypeByUuidAndGroupId((String)uuid, (long)groupId);
        if (dlFileEntryType != null) {
            DLFileEntryTypeLocalServiceUtil.deleteFileEntryType((DLFileEntryType)dlFileEntryType);
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) {
        HashMap<String, String> referenceAttributes = new HashMap<String, String>();
        referenceAttributes.put("file-entry-type-key", fileEntryType.getFileEntryTypeKey());
        long defaultUserId = 0L;
        try {
            defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)fileEntryType.getCompanyId());
        }
        catch (Exception exception) {
            return referenceAttributes;
        }
        boolean preloaded = false;
        if (defaultUserId == fileEntryType.getUserId()) {
            preloaded = true;
        }
        referenceAttributes.put("preloaded", String.valueOf(preloaded));
        return referenceAttributes;
    }

    public void importCompanyStagedModel(PortletDataContext portletDataContext, Element element) throws PortletDataException {
        String uuid = element.attributeValue("uuid");
        String fileEntryTypeKey = element.attributeValue("file-entry-type-key");
        boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
        DLFileEntryType existingFileEntryType = null;
        try {
            existingFileEntryType = this.getExistingFileEntryType(uuid, portletDataContext.getCompanyGroupId(), fileEntryTypeKey, preloaded);
        }
        catch (Exception e2) {
            throw new PortletDataException((Throwable)e2);
        }
        Map fileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
        long fileEntryTypeId = GetterUtil.getLong((String)element.attributeValue("class-pk"));
        fileEntryTypeIds.put(fileEntryTypeId, existingFileEntryType.getFileEntryTypeId());
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        String uuid = referenceElement.attributeValue("uuid");
        String fileEntryTypeKey = referenceElement.attributeValue("file-entry-type-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        try {
            DLFileEntryType existingFileEntryType = this.getExistingFileEntryType(uuid, portletDataContext.getScopeGroupId(), fileEntryTypeKey, preloaded);
            if (existingFileEntryType == null) {
                existingFileEntryType = this.getExistingFileEntryType(uuid, portletDataContext.getCompanyGroupId(), fileEntryTypeKey, preloaded);
            }
            return existingFileEntryType != null;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) throws Exception {
        Element fileEntryTypeElement = portletDataContext.getExportDataElement((ClassedModel)fileEntryType);
        List ddmStructures = fileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            Element referenceElement = StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntryType, (StagedModel)ddmStructure, (String)"strong");
            referenceElement.addAttribute("structure-id", StringUtil.valueOf((Object)ddmStructure.getStructureId()));
        }
        long defaultUserId = UserLocalServiceUtil.getDefaultUserId((long)fileEntryType.getCompanyId());
        if (defaultUserId == fileEntryType.getUserId()) {
            fileEntryTypeElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(fileEntryTypeElement, ExportImportPathUtil.getModelPath((StagedModel)fileEntryType), (ClassedModel)fileEntryType);
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) throws Exception {
        long userId = portletDataContext.getUserId(fileEntryType.getUserUuid());
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)fileEntryType, DDMStructure.class);
        List ddmStructureReferenceElements = portletDataContext.getReferenceElements((StagedModel)fileEntryType, DDMStructure.class);
        long[] ddmStructureIdsArray = new long[ddmStructureReferenceElements.size()];
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(DDMStructure.class);
        int i2 = 0;
        while (i2 < ddmStructureReferenceElements.size()) {
            Element ddmStructureReferenceElement = (Element)ddmStructureReferenceElements.get(i2);
            long ddmStructureId = GetterUtil.getLong((String)ddmStructureReferenceElement.attributeValue("class-pk"));
            ddmStructureIdsArray[i2] = MapUtil.getLong((Map)ddmStructureIds, (long)ddmStructureId);
            ++i2;
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileEntryType);
        DLFileEntryType importedDLFileEntryType = null;
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)fileEntryType);
        boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileEntryType existingDLFileEntryType = this.getExistingFileEntryType(fileEntryType.getUuid(), portletDataContext.getScopeGroupId(), fileEntryType.getFileEntryTypeKey(), preloaded);
            if (existingDLFileEntryType == null) {
                serviceContext.setUuid(fileEntryType.getUuid());
                importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)fileEntryType.getFileEntryTypeKey(), (Map)fileEntryType.getNameMap(), (Map)fileEntryType.getDescriptionMap(), (long[])ddmStructureIdsArray, (ServiceContext)serviceContext);
            } else {
                DLFileEntryTypeLocalServiceUtil.updateFileEntryType((long)userId, (long)existingDLFileEntryType.getFileEntryTypeId(), (Map)fileEntryType.getNameMap(), (Map)fileEntryType.getDescriptionMap(), (long[])ddmStructureIdsArray, (ServiceContext)serviceContext);
                importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryType((long)existingDLFileEntryType.getFileEntryTypeId());
            }
        } else {
            importedDLFileEntryType = DLFileEntryTypeLocalServiceUtil.addFileEntryType((long)userId, (long)portletDataContext.getScopeGroupId(), (String)fileEntryType.getFileEntryTypeKey(), (Map)fileEntryType.getNameMap(), (Map)fileEntryType.getDescriptionMap(), (long[])ddmStructureIdsArray, (ServiceContext)serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileEntryType, (ClassedModel)importedDLFileEntryType);
        if (preloaded) {
            return;
        }
        String importedDLFileEntryDDMStructureKey = DLUtil.getDDMStructureKey((DLFileEntryType)importedDLFileEntryType);
        List importedDDMStructures = importedDLFileEntryType.getDDMStructures();
        for (DDMStructure importedDDMStructure : importedDDMStructures) {
            String ddmStructureKey = importedDDMStructure.getStructureKey();
            if (!DLUtil.isAutoGeneratedDLFileEntryTypeDDMStructureKey((String)ddmStructureKey) || ddmStructureKey.equals(importedDLFileEntryDDMStructureKey)) continue;
            importedDDMStructure.setStructureKey(importedDLFileEntryDDMStructureKey);
            DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)importedDDMStructure);
        }
    }

    protected DLFileEntryType getExistingFileEntryType(String uuid, long groupId, String fileEntryTypeKey, boolean preloaded) throws Exception {
        DLFileEntryType existingDLFileEntryType = null;
        existingDLFileEntryType = !preloaded ? DLFileEntryTypeLocalServiceUtil.fetchDLFileEntryTypeByUuidAndGroupId((String)uuid, (long)groupId) : DLFileEntryTypeLocalServiceUtil.fetchFileEntryType((long)groupId, (String)fileEntryTypeKey);
        return existingDLFileEntryType;
    }
}

