/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.ints;

import it.unimi.dsi.fastutil.ints.AbstractIntComparator;
import it.unimi.dsi.fastutil.ints.IntComparator;

public class IntComparators {
    public static final IntComparator NATURAL_COMPARATOR = new AbstractIntComparator(){

        @Override
        public final int compare(int a, int b) {
            return a < b ? -1 : (a == b ? 0 : 1);
        }
    };
    public static final IntComparator OPPOSITE_COMPARATOR = new AbstractIntComparator(){

        @Override
        public final int compare(int a, int b) {
            return -(a < b ? -1 : (a == b ? 0 : 1));
        }
    };

    private IntComparators() {
    }

    public static IntComparator oppositeComparator(final IntComparator c) {
        return new AbstractIntComparator(){
            private final IntComparator comparator;
            {
                this.comparator = c;
            }

            @Override
            public final int compare(int a, int b) {
                return -this.comparator.compare(a, b);
            }
        };
    }
}

