/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.http.mirror;

import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.xml.XMLHelper;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class HTTPWriterMirror
extends Thread
implements IMirror {
    private static Logger logger = Logger.getLogger(HTTPWriterMirror.class.getName());
    private static final int TIMEOUT = 100000;
    private String key = null;
    private IMirror.MirroringState state = IMirror.MirroringState.Open;
    private Socket socket;
    private OutputStream out;
    private IBuffer buffer = null;
    private String request = null;
    private int readerNeeded = 0;
    private boolean doDispose = false;
    private PartialRequestEntry[] partials = null;
    public static final int dataformat = 0;
    private BlockingQueue<Request> requests = new LinkedBlockingQueue<Request>(2);
    private Request req = null;

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    public synchronized void handle(String request, Socket socket, BufferedOutputStream out) throws GRS2ProxyMirrorInvalidOperationException {
        if (this.key == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No key defined");
        }
        Request r = new Request();
        r.request = request;
        r.socket = socket;
        r.out = out;
        if (this.buffer != null) {
            this.requests.add(r);
        } else {
            this.req = r;
            this.setDaemon(true);
            this.setName("writer mirror (" + this.key + ")");
            this.start();
        }
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean purge) {
        if (this.state == IMirror.MirroringState.Purged) {
            return;
        }
        this.state = purge ? IMirror.MirroringState.Purged : IMirror.MirroringState.Close;
        if (purge) {
            try {
                this.closeSocket();
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (this.buffer != null) {
                    this.buffer.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean pollPartial(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorInvalidOperationException {
        throw new GRS2ProxyMirrorInvalidOperationException("Operation not supported in writer mirror");
    }

    @Override
    public long requestPartial(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorInvalidOperationException {
        throw new GRS2ProxyMirrorInvalidOperationException("Operation not supported in writer mirror");
    }

    private void writerAcceptRequests() throws Exception {
        Document doc = null;
        doc = XMLHelper.getXMLDocument(this.request);
        logger.log(Level.FINEST, "HTTPWriterMirror : parseRequest....");
        this.parseRequest(doc);
        logger.log(Level.FINEST, "HTTPWriterMirror : parseRequest....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : retrieveEvents....");
        this.retrieveEvents(doc);
        logger.log(Level.FINEST, "HTTPWriterMirror : retrieveEvents....OK");
    }

    private void writerEmptyResponse() throws Exception {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GRS2Exception("Couldn't create an XML document", e);
        }
        Document doc = docBuilder.newDocument();
        Element element = doc.createElement("response");
        doc.appendChild(element);
        XMLHelper.sendXML(doc, this.out);
    }

    private boolean writerResponse() throws Exception {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GRS2Exception("Couldn't create an XML document", e);
        }
        Document doc = docBuilder.newDocument();
        Element element = doc.createElement("response");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushPartialRequests....");
        this.flushPartialRequests(doc, element);
        logger.log(Level.FINEST, "HTTPWriterMirror : flushPartialRequests....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushForwardBuffer....");
        this.flushForwardBuffer(doc, element);
        logger.log(Level.FINEST, "HTTPWriterMirror : flushForwardBuffer....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushEvents....");
        this.flushEvents(doc, element);
        logger.log(Level.FINEST, "HTTPWriterMirror : flushEvents....OK");
        logger.log(Level.FINEST, "HTTPWriterMirror : flushStatus....");
        boolean breakLoop = this.flushStatus(doc, element);
        logger.log(Level.FINEST, "HTTPWriterMirror : flushStatus....OK");
        doc.appendChild(element);
        XMLHelper.sendXML(doc, this.out);
        return breakLoop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.buffer = GRSRegistry.Registry.getBuffer(this.key);
            if (this.buffer == null && (this.state == IMirror.MirroringState.Close || this.state == IMirror.MirroringState.Purged)) {
                throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is already closed. Cannot initialize the protocol");
            }
            if (this.buffer == null && this.state == IMirror.MirroringState.Open) {
                throw new GRS2ProxyMirrorInvalidOperationException("No registry entry found for key " + this.key);
            }
            if (this.req == null || this.req.request == null) {
                throw new GRS2ProxyMirrorProtocolErrorException("Writer timed out!");
            }
            this.socket = this.req.socket;
            this.request = this.req.request;
            this.out = this.req.out;
            try {
                this.out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                this.flushBufferConfig();
                this.closeSocket();
            }
            catch (Exception ex) {
                throw new GRS2ProxyMirrorProtocolErrorException("Could not complete buffer configuration mirroring", ex);
            }
            this.req = null;
            while (true) {
                this.req = this.requests.poll(100000L, TimeUnit.MILLISECONDS);
                if (this.req == null || this.req.request == null) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Writer timed out!");
                }
                this.socket = this.req.socket;
                this.request = this.req.request;
                this.out = this.req.out;
                this.out.write("HTTP/1.1 200 OK\r\n\r\n".getBytes());
                if (this.state == IMirror.MirroringState.Purged) break;
                if (this.state == IMirror.MirroringState.Close) {
                    break;
                }
                try {
                    this.writerAcceptRequests();
                }
                catch (Exception ex) {
                    throw new GRS2ProxyMirrorProtocolErrorException("Could not parse input request", ex);
                }
                if (this.doDispose) {
                    logger.log(Level.FINEST, "Writer mirror received dispose request");
                    this.writerEmptyResponse();
                    break;
                }
                if (this.state == IMirror.MirroringState.Purged) {
                    break;
                }
                if (this.writerResponse()) {
                    break;
                }
                this.req = null;
                this.closeSocket();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            if (this.state == IMirror.MirroringState.Open && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Unrecoverable error during mirroring process", ex);
            } else if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Unrecoverable error during mirroring process", ex);
            }
        }
        finally {
            logger.log(Level.FINEST, "Writer finished work");
            this.dispose(true);
        }
        this.closeSocket();
    }

    private boolean flushStatus(Document doc, Element element) throws Exception {
        Element el = doc.createElement("status");
        Integer value = null;
        value = this.state == IMirror.MirroringState.Close ? Integer.valueOf(2) : (this.buffer.getStatus() == IBuffer.Status.Close && this.buffer.availableRecords() == 0 ? Integer.valueOf(1) : Integer.valueOf(0));
        el.setTextContent(String.valueOf(value));
        element.appendChild(el);
        return value == 2;
    }

    private void flushBufferConfig() throws Exception {
        DocumentBuilder docBuilder;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GRS2Exception("Couldn't create an XML document", e);
        }
        Document doc = docBuilder.newDocument();
        Element bufferConfig = doc.createElement("bufferConfig");
        Element el = doc.createElement("bufferClass");
        el.setTextContent(this.buffer.getClass().getName());
        bufferConfig.appendChild(el);
        el = doc.createElement("capacity");
        el.setTextContent(String.valueOf(this.buffer.getCapacity()));
        bufferConfig.appendChild(el);
        el = doc.createElement("concurrentPartialCapacity");
        el.setTextContent(String.valueOf(this.buffer.getConcurrentPartialCapacity()));
        bufferConfig.appendChild(el);
        el = doc.createElement("inactivityTimeout");
        el.setTextContent(String.valueOf(this.buffer.getInactivityTimeout()));
        bufferConfig.appendChild(el);
        el = doc.createElement("inactivityTimeUnit");
        el.setTextContent(String.valueOf(this.buffer.getInactivityTimeUnit().toString()));
        bufferConfig.appendChild(el);
        el = doc.createElement("transportDirective");
        el.setTextContent(String.valueOf(this.buffer.getTransportDirective().toString()));
        bufferConfig.appendChild(el);
        el = doc.createElement("recordDefinitions");
        if (this.buffer.getRecordDefinitions() != null && this.buffer.getRecordDefinitions().length > 0) {
            for (RecordDefinition def : this.buffer.getRecordDefinitions()) {
                Element rd = doc.createElement("recordDefinition");
                Element rdClass = doc.createElement("recordDefinitionClass");
                rdClass.setTextContent(def.getClass().getName());
                rd.appendChild(def.toXML(doc));
                rd.appendChild(rdClass);
                el.appendChild(rd);
            }
        }
        bufferConfig.appendChild(el);
        doc.appendChild(bufferConfig);
        XMLHelper.sendXML(doc, this.out);
    }

    private void parseRequest(Document doc) throws IOException, ClassNotFoundException, ParserConfigurationException, SAXException {
        Element element = doc.getDocumentElement();
        element = (Element)element.getElementsByTagName("request").item(0);
        this.doDispose = Boolean.valueOf(element.getElementsByTagName("doDispose").item(0).getTextContent());
        this.readerNeeded = Integer.valueOf(element.getElementsByTagName("needed").item(0).getTextContent());
        boolean simulateActivity = Boolean.valueOf(element.getElementsByTagName("simulateActivity").item(0).getTextContent());
        if (simulateActivity) {
            this.buffer.markSimulateActivity();
        }
        if (element.getElementsByTagName("partialRequestEntries").item(0) != null) {
            NodeList partialRequestEntries = element.getElementsByTagName("partialRequestEntries").item(0).getChildNodes();
            int len = partialRequestEntries.getLength();
            this.partials = new PartialRequestEntry[len];
            for (int i = 0; i < len; ++i) {
                Element partialRequestEntry = (Element)partialRequestEntries.item(i);
                long recordIndex = Long.valueOf(partialRequestEntry.getElementsByTagName("recordIndex").item(0).getTextContent());
                int fieldIndex = Integer.valueOf(partialRequestEntry.getElementsByTagName("fieldIndex").item(0).getTextContent());
                String traspOverride = partialRequestEntry.getElementsByTagName("override").item(0).getTextContent();
                IBuffer.TransportOverride override = IBuffer.TransportOverride.valueOf(traspOverride);
                this.partials[i] = new PartialRequestEntry(recordIndex, fieldIndex, override, null);
            }
        }
    }

    private void retrieveEvents(Document doc) throws IOException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2RecordSerializationException, GRS2BufferException, GRS2RecordDefinitionException, DOMException {
        Element element = doc.getDocumentElement();
        if (element.getElementsByTagName("events") == null || element.getElementsByTagName("events").getLength() == 0) {
            return;
        }
        NodeList events = element.getElementsByTagName("events").item(0).getChildNodes();
        int len = events.getLength();
        for (int i = 0; i < len; ++i) {
            Element event = (Element)events.item(i);
            String eventType = event.getElementsByTagName("eventType").item(0).getTextContent();
            BufferEvent ev = (BufferEvent)Class.forName(eventType).newInstance();
            ev.fromXML(event);
            this.buffer.emit(ev);
        }
    }

    private void flushEvents(Document doc, Element element) throws Exception {
        BufferEvent event;
        Element events = doc.createElement("events");
        while ((event = this.buffer.receive(BufferEvent.EventSource.Writer)) != null) {
            Element eventEl = doc.createElement("event");
            Element eventType = doc.createElement("eventType");
            eventType.setTextContent(event.getClass().getName());
            eventEl.appendChild(eventType);
            Element eventExt = event.toXML(doc);
            eventEl.appendChild(eventExt);
            events.appendChild(eventEl);
        }
        element.appendChild(events);
    }

    private void flushPartialRequests(Document doc, Element element) throws Exception {
        Element partRecords = doc.createElement("partialRecords");
        boolean i = true;
        if (partRecords != null && this.partials != null) {
            for (PartialRequestEntry entry : this.partials) {
                Record rec = this.buffer.locate(entry.getRecordIndex());
                if (rec == null) {
                    throw new GRS2ProxyMirrorInvalidOperationException("Invalid record index provided");
                }
                Field[] fields = rec.getFields();
                if (fields == null) {
                    throw new GRS2ProxyMirrorInvalidOperationException("No fields to marshal");
                }
                if (entry.getFieldIndex() < 0 || entry.getFieldIndex() >= fields.length) {
                    throw new GRS2ProxyMirrorInvalidOperationException("Invalid field index provided");
                }
                Field f = fields[entry.getFieldIndex()];
                Element partRecord = doc.createElement("partialRecord");
                Element el = doc.createElement("partRecordIndex");
                el.setTextContent(String.valueOf(entry.getRecordIndex()));
                partRecord.appendChild(el);
                el = doc.createElement("fieldIndex");
                el.setTextContent(String.valueOf(entry.getFieldIndex()));
                partRecord.appendChild(el);
                el = doc.createElement("override");
                el.setTextContent(String.valueOf((Object)entry.getOverride()));
                partRecord.appendChild(el);
                f.extendSendToXML(doc, partRecord, entry.getOverride());
                partRecords.appendChild(partRecord);
            }
        }
        element.appendChild(partRecords);
    }

    private void flushForwardBuffer(Document doc, Element element) throws Exception {
        Element records = doc.createElement("records");
        long available = this.buffer.availableRecords();
        long mirrorBuffer = this.buffer.getMirrorBuffer();
        long toMirror = this.readerNeeded;
        if (toMirror > available) {
            toMirror = available;
        }
        if (toMirror > mirrorBuffer) {
            toMirror = mirrorBuffer;
        }
        int i = 0;
        while ((long)i < toMirror) {
            Record rec = this.buffer.get();
            if (rec == null) {
                if (!logger.isLoggable(Level.WARNING)) break;
                logger.log(Level.WARNING, "Record not available although declared as available");
                break;
            }
            Element el = doc.createElement("record");
            Element recClassEl = doc.createElement("recordClass");
            recClassEl.setTextContent(rec.getClass().getName());
            el.appendChild(recClassEl);
            Element recEl = rec.sendToXML(doc);
            el.appendChild(recEl);
            records.appendChild(el);
            ++i;
        }
        element.appendChild(records);
    }

    private void closeSocket() {
        logger.log(Level.FINEST, "Writer closed socket");
        this.request = null;
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
                this.out = null;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class Request {
        protected String request;
        protected Socket socket;
        protected BufferedOutputStream out;

        private Request() {
        }
    }
}

