/*
 * Decompiled with CFR 0.152.
 */
package org.incava.util.diff;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeMap;
import org.incava.util.diff.Difference;

public class Diff {
    protected Object[] a;
    protected Object[] b;
    protected List diffs = new ArrayList();
    private Difference pending;
    private Comparator comparator;
    private TreeMap thresh;

    public Diff(Object[] objectArray, Object[] objectArray2, Comparator comparator) {
        this.a = objectArray;
        this.b = objectArray2;
        this.comparator = comparator;
        this.thresh = null;
    }

    public Diff(Object[] objectArray, Object[] objectArray2) {
        this(objectArray, objectArray2, null);
    }

    public Diff(Collection collection, Collection collection2, Comparator comparator) {
        this(collection.toArray(), collection2.toArray(), comparator);
    }

    public Diff(Collection collection, Collection collection2) {
        this(collection, collection2, null);
    }

    public List diff() {
        this.traverseSequences();
        if (this.pending != null) {
            this.diffs.add(this.pending);
        }
        return this.diffs;
    }

    protected void traverseSequences() {
        int n;
        Integer[] integerArray = this.getLongestCommonSubsequences();
        int n2 = this.a.length - 1;
        int n3 = this.b.length - 1;
        int n4 = 0;
        int n5 = integerArray.length - 1;
        for (n = 0; n <= n5; ++n) {
            Integer n6 = integerArray[n];
            if (n6 == null) {
                this.onANotB(n, n4);
                continue;
            }
            while (n4 < n6) {
                this.onBNotA(n, n4++);
            }
            this.onMatch(n, n4++);
        }
        boolean bl = false;
        boolean bl2 = false;
        while (n <= n2 || n4 <= n3) {
            if (n == n2 + 1 && n4 <= n3) {
                if (!bl && this.callFinishedA()) {
                    this.finishedA(n2);
                    bl = true;
                } else {
                    while (n4 <= n3) {
                        this.onBNotA(n, n4++);
                    }
                }
            }
            if (n4 == n3 + 1 && n <= n2) {
                if (!bl2 && this.callFinishedB()) {
                    this.finishedB(n3);
                    bl2 = true;
                } else {
                    while (n <= n2) {
                        this.onANotB(n++, n4);
                    }
                }
            }
            if (n <= n2) {
                this.onANotB(n++, n4);
            }
            if (n4 > n3) continue;
            this.onBNotA(n, n4++);
        }
    }

    protected boolean callFinishedA() {
        return false;
    }

    protected boolean callFinishedB() {
        return false;
    }

    protected void finishedA(int n) {
    }

    protected void finishedB(int n) {
    }

    protected void onANotB(int n, int n2) {
        if (this.pending == null) {
            this.pending = new Difference(n, n, n2, -1);
        } else {
            this.pending.setDeleted(n);
        }
    }

    protected void onBNotA(int n, int n2) {
        if (this.pending == null) {
            this.pending = new Difference(n, -1, n2, n2);
        } else {
            this.pending.setAdded(n2);
        }
    }

    protected void onMatch(int n, int n2) {
        if (this.pending != null) {
            this.diffs.add(this.pending);
            this.pending = null;
        }
    }

    protected boolean equals(Object object, Object object2) {
        return this.comparator == null ? object.equals(object2) : this.comparator.compare(object, object2) == 0;
    }

    public Integer[] getLongestCommonSubsequences() {
        Integer n;
        List<Integer> list;
        Object object;
        int n2 = 0;
        int n3 = this.a.length - 1;
        int n4 = 0;
        int n5 = this.b.length - 1;
        TreeMap<Object, Integer> treeMap = new TreeMap<Object, Integer>();
        while (n2 <= n3 && n4 <= n5 && this.equals(this.a[n2], this.b[n4])) {
            treeMap.put(new Integer(n2++), new Integer(n4++));
        }
        while (n2 <= n3 && n4 <= n5 && this.equals(this.a[n3], this.b[n5])) {
            treeMap.put(new Integer(n3--), new Integer(n5--));
        }
        AbstractMap abstractMap = null;
        abstractMap = this.comparator == null ? (this.a.length > 0 && this.a[0] instanceof Comparable ? new TreeMap() : new HashMap()) : new TreeMap(this.comparator);
        for (int i = n4; i <= n5; ++i) {
            Object[] objectArray = this.b[i];
            object = objectArray;
            list = (ArrayList<Integer>)abstractMap.get(object);
            if (list == null) {
                list = new ArrayList<Integer>();
                abstractMap.put(object, list);
            }
            list.add(new Integer(i));
        }
        this.thresh = new TreeMap();
        HashMap<Integer, Object[]> hashMap = new HashMap<Integer, Object[]>();
        for (int i = n2; i <= n3; ++i) {
            object = this.a[i];
            list = (List)abstractMap.get(object);
            if (list == null) continue;
            n = new Integer(0);
            ListIterator listIterator = list.listIterator(list.size());
            while (listIterator.hasPrevious()) {
                Integer n6 = (Integer)listIterator.previous();
                n = this.insert(n6, n);
                if (n == null) continue;
                Object var14_17 = n > 0 ? hashMap.get(new Integer(n - 1)) : null;
                hashMap.put(n, new Object[]{var14_17, new Integer(i), n6});
            }
        }
        if (this.thresh.size() > 0) {
            Integer n7 = (Integer)this.thresh.lastKey();
            object = (Object[])hashMap.get(n7);
            while (object != null) {
                list = (Integer)object[1];
                n = (Integer)object[2];
                treeMap.put(list, n);
                object = (Object[])object[0];
            }
        }
        return Diff.toArray(treeMap);
    }

    protected static Integer[] toArray(TreeMap treeMap) {
        int n = treeMap.size() == 0 ? 0 : 1 + (Integer)treeMap.lastKey();
        Integer[] integerArray = new Integer[n];
        Iterator iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            Integer n2;
            Integer n3 = (Integer)iterator.next();
            integerArray[n3.intValue()] = n2 = (Integer)treeMap.get(n3);
        }
        return integerArray;
    }

    protected static boolean isNonzero(Integer n) {
        return n != null && n != 0;
    }

    protected boolean isGreaterThan(Integer n, Integer n2) {
        Integer n3 = (Integer)this.thresh.get(n);
        return n3 != null && n2 != null && n3.compareTo(n2) > 0;
    }

    protected boolean isLessThan(Integer n, Integer n2) {
        Integer n3 = (Integer)this.thresh.get(n);
        return n3 != null && (n2 == null || n3.compareTo(n2) < 0);
    }

    protected Integer getLastValue() {
        return (Integer)this.thresh.get(this.thresh.lastKey());
    }

    protected void append(Integer n) {
        Integer n2 = null;
        if (this.thresh.size() == 0) {
            n2 = new Integer(0);
        } else {
            Integer n3 = (Integer)this.thresh.lastKey();
            n2 = new Integer(n3 + 1);
        }
        this.thresh.put(n2, n);
    }

    protected Integer insert(Integer n, Integer n2) {
        if (Diff.isNonzero(n2) && this.isGreaterThan(n2, n) && this.isLessThan(new Integer(n2 - 1), n)) {
            this.thresh.put(n2, n);
        } else {
            int n3 = -1;
            if (Diff.isNonzero(n2)) {
                n3 = n2;
            } else if (this.thresh.size() > 0) {
                n3 = (Integer)this.thresh.lastKey();
            }
            if (n3 == -1 || n.compareTo(this.getLastValue()) > 0) {
                this.append(n);
                n2 = new Integer(n3 + 1);
            } else {
                int n4 = 0;
                while (n4 <= n3) {
                    int n5 = (n3 + n4) / 2;
                    Integer n6 = (Integer)this.thresh.get(new Integer(n5));
                    int n7 = n.compareTo(n6);
                    if (n7 == 0) {
                        return null;
                    }
                    if (n7 > 0) {
                        n4 = n5 + 1;
                        continue;
                    }
                    n3 = n5 - 1;
                }
                this.thresh.put(new Integer(n4), n);
                n2 = new Integer(n4);
            }
        }
        return n2;
    }
}

