/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.util.servlet.filters;

import com.liferay.portal.kernel.servlet.BufferCacheServletResponse;
import com.liferay.portal.kernel.servlet.Header;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class CacheResponseData
implements Serializable {
    private Map<String, Object> _attributes = new HashMap<String, Object>();
    private transient byte[] _content;
    private String _contentType;
    private Map<String, Set<Header>> _headers;
    private transient int _length;
    private final transient int _offset;
    private boolean _valid;

    public CacheResponseData() {
        this._content = null;
        this._contentType = null;
        this._headers = null;
        this._length = 0;
        this._offset = 0;
        this._valid = false;
    }

    public CacheResponseData(BufferCacheServletResponse bufferCacheServletResponse) throws IOException {
        ByteBuffer byteBuffer = bufferCacheServletResponse.getByteBuffer();
        this._content = byteBuffer.array();
        this._contentType = bufferCacheServletResponse.getContentType();
        this._headers = bufferCacheServletResponse.getHeaders();
        this._length = byteBuffer.remaining();
        this._offset = byteBuffer.arrayOffset() + byteBuffer.position();
        this._valid = true;
    }

    public Object getAttribute(String name) {
        return this._attributes.get(name);
    }

    public ByteBuffer getByteBuffer() {
        return ByteBuffer.wrap(this._content, this._offset, this._length);
    }

    public String getContentType() {
        return this._contentType;
    }

    public Map<String, Set<Header>> getHeaders() {
        return this._headers;
    }

    public boolean isValid() {
        return this._valid;
    }

    public void setAttribute(String name, Object value) {
        this._attributes.put(name, value);
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this._length = objectInputStream.readInt();
        this._content = new byte[this._length];
        objectInputStream.readFully(this._content);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._length);
        objectOutputStream.write(this._content, this._offset, this._length);
    }
}

