/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp;

import gr.uoa.di.madgik.commons.server.TCPConnectionManager;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.registry.GRSRegistry;
import gr.uoa.di.madgik.grs.store.buffer.BufferStoreFactory;
import gr.uoa.di.madgik.grs.store.buffer.GRS2BufferStoreException;
import gr.uoa.di.madgik.grs.store.buffer.IBufferStore;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeUnit;

public class TCPStoreWriterProxy
implements IProxy {
    public static URI store(URI[] locators, IBufferStore.MultiplexType multiplex, long timeout, TimeUnit unit) throws GRS2BufferStoreException, GRS2ProxyInvalidArgumentException {
        IBufferStore store = null;
        try {
            String hostname = TCPConnectionManager.GetConnectionManagerHostName();
            int port = TCPConnectionManager.GetConnectionManagerPort();
            store = BufferStoreFactory.getManager();
            store.setLocators(locators);
            store.setMultiplexType(multiplex);
            store.setReaderTimeout(timeout);
            store.setReaderTimeoutTimeUnit(unit);
            store.initialize();
            store.store();
            String key = GRSRegistry.Registry.add(store);
            store.setKey(key);
            return new URI("grs2-store-proxy", null, hostname, port, null, "key=" + key, IProxy.ProxyType.TCPStore.toString());
        }
        catch (GRS2BufferStoreException ex) {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw ex;
        }
        catch (URISyntaxException exx) {
            if (store != null) {
                try {
                    store.dispose();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidArgumentException("Could not create store uri", exx);
        }
    }
}

