/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.search.lucene;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.nio.intraband.rpc.IntrabandRPCUtil;
import com.liferay.portal.kernel.process.ProcessCallable;
import com.liferay.portal.kernel.resiliency.mpi.MPIHelperUtil;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIUtil;
import com.liferay.portal.kernel.search.SearchEngineUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.search.lucene.IndexAccessor;
import com.liferay.portal.search.lucene.IndexSearcherManager;
import com.liferay.portal.search.lucene.LuceneHelperUtil;
import com.liferay.portal.search.lucene.dump.DumpIndexDeletionPolicy;
import com.liferay.portal.search.lucene.dump.IndexCommitSerializationUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.LimitTokenCountAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.LogMergePolicy;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.NoMergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.RAMDirectory;

public class IndexAccessorImpl
implements IndexAccessor {
    private static final String _LUCENE_STORE_TYPE_FILE = "file";
    private static final String _LUCENE_STORE_TYPE_JDBC = "jdbc";
    private static final String _LUCENE_STORE_TYPE_RAM = "ram";
    private static Log _log = LogFactoryUtil.getLog(IndexAccessorImpl.class);
    private volatile int _batchCount;
    private Lock _commitLock = new ReentrantLock();
    private long _companyId;
    private Directory _directory;
    private DumpIndexDeletionPolicy _dumpIndexDeletionPolicy = new DumpIndexDeletionPolicy();
    private IndexSearcherManager _indexSearcherManager;
    private IndexWriter _indexWriter;
    private String _path;
    private Map<String, Directory> _ramDirectories = new ConcurrentHashMap<String, Directory>();
    private ScheduledExecutorService _scheduledExecutorService;

    public IndexAccessorImpl(long companyId) {
        this._companyId = companyId;
        this._path = PropsValues.LUCENE_DIR.concat(String.valueOf(this._companyId)).concat("/");
        try {
            if (!SPIUtil.isSPI()) {
                this._checkLuceneDir();
                this._initIndexWriter();
                this._initCommitScheduler();
                this._indexSearcherManager = new IndexSearcherManager(this._indexWriter);
            } else {
                this._indexSearcherManager = new IndexSearcherManager(this.getLuceneDir());
            }
        }
        catch (IOException ioe) {
            _log.error((Object)("Unable to initialize index searcher manager for company " + this._companyId), (Throwable)ioe);
        }
    }

    @Override
    public IndexSearcher acquireIndexSearcher() throws IOException {
        return this._indexSearcherManager.acquire();
    }

    @Override
    public void addDocument(Document document) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this._write(null, document);
    }

    @Override
    public void addDocuments(Collection<Document> documents) throws IOException {
        try {
            for (Document document : documents) {
                this._indexWriter.addDocument(document);
            }
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }

    @Override
    public void close() {
        if (SPIUtil.isSPI()) {
            return;
        }
        try {
            this._indexSearcherManager.close();
            this._indexWriter.close();
            this._directory.close();
        }
        catch (Exception e2) {
            _log.error((Object)("Closing Lucene writer failed for " + this._companyId), (Throwable)e2);
        }
        if (this._scheduledExecutorService != null) {
            this._scheduledExecutorService.shutdownNow();
        }
    }

    @Override
    public void delete() {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        this._deleteDirectory();
    }

    @Override
    public void deleteDocuments(Term term) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            this._indexWriter.deleteDocuments(term);
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }

    @Override
    public void dumpIndex(OutputStream outputStream) throws IOException {
        try {
            this._dumpIndexDeletionPolicy.dump(outputStream, this._indexWriter, this._commitLock);
        }
        finally {
            this._indexSearcherManager.invalidate();
        }
    }

    @Override
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public long getLastGeneration() {
        return this._dumpIndexDeletionPolicy.getLastGeneration();
    }

    @Override
    public Directory getLuceneDir() {
        if (this._directory != null) {
            return this._directory;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Lucene store type " + PropsValues.LUCENE_STORE_TYPE));
        }
        if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_FILE)) {
            this._directory = this._getLuceneDirFile();
        } else {
            if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
                throw new IllegalArgumentException("Store type JDBC is no longer supported in favor of SOLR");
            }
            if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_RAM)) {
                this._directory = new RAMDirectory();
            } else {
                throw new RuntimeException("Invalid store type " + PropsValues.LUCENE_STORE_TYPE);
            }
        }
        return this._directory;
    }

    @Override
    public void invalidate() {
        this._indexSearcherManager.invalidate();
    }

    @Override
    public void loadIndex(InputStream inputStream) throws IOException {
        File tempFile = FileUtil.createTempFile();
        FSDirectory tempDirectory = FSDirectory.open((File)tempFile);
        if (OSDetector.isWindows() && PropsValues.INDEX_DUMP_PROCESS_DOCUMENTS_ENABLED) {
            IndexSearcher indexSearcher;
            IndexReader indexReader;
            block6: {
                IndexCommitSerializationUtil.deserializeIndex(inputStream, (Directory)tempDirectory);
                this._deleteDirectory();
                indexReader = IndexReader.open((Directory)tempDirectory, (boolean)false);
                indexSearcher = new IndexSearcher(indexReader);
                try {
                    ScoreDoc[] scoreDocs;
                    TopDocs topDocs = indexSearcher.search((Query)new MatchAllDocsQuery(), indexReader.numDocs());
                    ScoreDoc[] scoreDocArray = scoreDocs = topDocs.scoreDocs;
                    int n = scoreDocs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ScoreDoc scoreDoc = scoreDocArray[n2];
                        Document document = indexSearcher.doc(scoreDoc.doc);
                        this.addDocument(document);
                        ++n2;
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!_log.isDebugEnabled()) break block6;
                    _log.debug((Object)iae.getMessage());
                }
            }
            indexSearcher.close();
            indexReader.flush();
            indexReader.close();
        } else {
            IndexCommitSerializationUtil.deserializeIndex(inputStream, (Directory)tempDirectory);
            this._indexSearcherManager.close();
            this._indexWriter.close();
            this._deleteDirectory();
            String[] stringArray = tempDirectory.listAll();
            int n = stringArray.length;
            int n3 = 0;
            while (n3 < n) {
                String file = stringArray[n3];
                tempDirectory.copy(this.getLuceneDir(), file, file);
                ++n3;
            }
            this._initIndexWriter();
            this._indexSearcherManager = new IndexSearcherManager(this._indexWriter);
        }
        tempDirectory.close();
        FileUtil.deltree((File)tempFile);
    }

    @Override
    public void releaseIndexSearcher(IndexSearcher indexSearcher) throws IOException {
        this._indexSearcherManager.release(indexSearcher);
    }

    @Override
    public void updateDocument(Term term, Document document) throws IOException {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing " + document));
        }
        this._write(term, document);
    }

    private static void _invalidate(long companyId) {
        for (SPI spi : MPIHelperUtil.getSPIs()) {
            try {
                RegistrationReference registrationReference = spi.getRegistrationReference();
                IntrabandRPCUtil.execute((RegistrationReference)registrationReference, (ProcessCallable)new InvalidateProcessCallable(companyId));
            }
            catch (Exception e2) {
                _log.error((Object)("Unable to invalidate SPI " + spi + " for company " + companyId), (Throwable)e2);
            }
        }
    }

    private void _checkLuceneDir() {
        if (SearchEngineUtil.isIndexReadOnly()) {
            return;
        }
        try {
            Directory directory = this.getLuceneDir();
            if (IndexWriter.isLocked((Directory)directory)) {
                IndexWriter.unlock((Directory)directory);
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Check Lucene directory failed for " + this._companyId), (Throwable)e2);
        }
    }

    private void _commit() throws IOException {
        if (PropsValues.LUCENE_COMMIT_BATCH_SIZE == 0 || PropsValues.LUCENE_COMMIT_BATCH_SIZE <= this._batchCount) {
            this._doCommit();
        }
    }

    private void _deleteAll() {
        block2: {
            try {
                this._indexWriter.deleteAll();
                this._doCommit();
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to delete index in directory " + this._path));
            }
        }
    }

    private void _deleteDirectory() {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Lucene store type " + PropsValues.LUCENE_STORE_TYPE));
        }
        if (!PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_FILE) && !PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_RAM)) {
            if (PropsValues.LUCENE_STORE_TYPE.equals(_LUCENE_STORE_TYPE_JDBC)) {
                throw new IllegalArgumentException("Store type JDBC is no longer supported in favor of SOLR");
            }
            throw new RuntimeException("Invalid store type " + PropsValues.LUCENE_STORE_TYPE);
        }
        this._deleteAll();
    }

    private void _doCommit() throws IOException {
        if (this._indexWriter != null) {
            this._commitLock.lock();
            try {
                this._indexWriter.commit();
            }
            finally {
                this._commitLock.unlock();
                this._indexSearcherManager.invalidate();
                IndexAccessorImpl._invalidate(this._companyId);
            }
        }
        this._batchCount = 0;
    }

    private Directory _getLuceneDirFile() {
        Object directory;
        block4: {
            directory = null;
            try {
                directory = PropsValues.LUCENE_STORE_TYPE_FILE_FORCE_MMAP ? new MMapDirectory(new File(this._path)) : FSDirectory.open((File)new File(this._path));
            }
            catch (IOException iOException) {
                if (directory == null) break block4;
                try {
                    directory.close();
                }
                catch (Exception exception) {}
            }
        }
        return directory;
    }

    private MergePolicy _getMergePolicy() throws Exception {
        if (PropsValues.LUCENE_MERGE_POLICY.equals(NoMergePolicy.class.getName())) {
            return NoMergePolicy.NO_COMPOUND_FILES;
        }
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        MergePolicy mergePolicy = (MergePolicy)InstanceFactory.newInstance((ClassLoader)classLoader, (String)PropsValues.LUCENE_MERGE_POLICY);
        if (mergePolicy instanceof LogMergePolicy) {
            LogMergePolicy logMergePolicy = (LogMergePolicy)mergePolicy;
            logMergePolicy.setMergeFactor(PropsValues.LUCENE_MERGE_FACTOR);
        }
        return mergePolicy;
    }

    private MergeScheduler _getMergeScheduler() throws Exception {
        if (PropsValues.LUCENE_MERGE_SCHEDULER.equals(NoMergeScheduler.class.getName())) {
            return NoMergeScheduler.INSTANCE;
        }
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        return (MergeScheduler)InstanceFactory.newInstance((ClassLoader)classLoader, (String)PropsValues.LUCENE_MERGE_SCHEDULER);
    }

    private void _initCommitScheduler() {
        if (PropsValues.LUCENE_COMMIT_BATCH_SIZE <= 0 || PropsValues.LUCENE_COMMIT_TIME_INTERVAL <= 0) {
            return;
        }
        this._scheduledExecutorService = Executors.newSingleThreadScheduledExecutor();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (IndexAccessorImpl.this._batchCount > 0) {
                        IndexAccessorImpl.this._doCommit();
                    }
                }
                catch (IOException ioe) {
                    _log.error((Object)"Could not run scheduled commit", (Throwable)ioe);
                }
            }
        };
        this._scheduledExecutorService.scheduleWithFixedDelay(runnable, 0L, PropsValues.LUCENE_COMMIT_TIME_INTERVAL, TimeUnit.MILLISECONDS);
    }

    private void _initIndexWriter() {
        try {
            LimitTokenCountAnalyzer analyzer = new LimitTokenCountAnalyzer(LuceneHelperUtil.getAnalyzer(), PropsValues.LUCENE_ANALYZER_MAX_TOKENS);
            IndexWriterConfig indexWriterConfig = new IndexWriterConfig(LuceneHelperUtil.getVersion(), (Analyzer)analyzer);
            indexWriterConfig.setIndexDeletionPolicy((IndexDeletionPolicy)this._dumpIndexDeletionPolicy);
            indexWriterConfig.setMergePolicy(this._getMergePolicy());
            indexWriterConfig.setMergeScheduler(this._getMergeScheduler());
            indexWriterConfig.setRAMBufferSizeMB((double)PropsValues.LUCENE_BUFFER_SIZE);
            this._indexWriter = new IndexWriter(this.getLuceneDir(), indexWriterConfig);
            if (!IndexReader.indexExists((Directory)this.getLuceneDir())) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Creating missing index");
                }
                this._indexWriter.commit();
            }
        }
        catch (Exception e2) {
            _log.error((Object)("Initializing Lucene writer failed for " + this._companyId), (Throwable)e2);
        }
    }

    private void _write(Term term, Document document) throws IOException {
        try {
            if (term != null) {
                this._indexWriter.updateDocument(term, document);
            } else {
                this._indexWriter.addDocument(document);
            }
            ++this._batchCount;
        }
        finally {
            this._commit();
        }
    }

    private static class InvalidateProcessCallable
    implements ProcessCallable<Serializable> {
        private static final long serialVersionUID = 1L;
        private final long _companyId;

        public InvalidateProcessCallable(long companyId) {
            this._companyId = companyId;
        }

        public Serializable call() {
            IndexAccessor indexAccessor = LuceneHelperUtil.getIndexAccessor(this._companyId);
            indexAccessor.invalidate();
            IndexAccessorImpl._invalidate(this._companyId);
            return null;
        }
    }
}

