/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.cache.ehcache;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Arrays;
import java.util.Properties;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;

public class LiferayCacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static Log _log = LogFactoryUtil.getLog(LiferayCacheManagerPeerProviderFactory.class);
    private static HtmlImpl _htmlUtil = new HtmlImpl();
    private CacheManagerPeerProviderFactory _cacheManagerPeerProviderFactory;

    public LiferayCacheManagerPeerProviderFactory() {
        String className = PropsValues.EHCACHE_CACHE_MANAGER_PEER_PROVIDER_FACTORY;
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Instantiating " + className + " " + ((Object)((Object)this)).hashCode()));
        }
        try {
            this._cacheManagerPeerProviderFactory = (CacheManagerPeerProviderFactory)InstanceFactory.newInstance((String)className);
        }
        catch (Exception e2) {
            throw new RuntimeException(e2);
        }
    }

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        String portalPropertyKey = properties.getProperty("portalPropertyKey");
        if (Validator.isNull((String)portalPropertyKey)) {
            throw new RuntimeException("portalPropertyKey is null");
        }
        Object[] values = PropsUtil.getArray(portalPropertyKey);
        if (_log.isInfoEnabled()) {
            _log.info((Object)("portalPropertyKey " + portalPropertyKey + " has value " + Arrays.toString(values)));
        }
        Properties portalProperties = new Properties();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            String[] valueParts = StringUtil.split((String)value, (char)'=');
            if (valueParts.length != 2 && _log.isWarnEnabled()) {
                _log.warn((Object)("Ignore malformed value " + (String)value));
            }
            portalProperties.put(valueParts[0], _htmlUtil.unescape(valueParts[1]));
            ++n2;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)PropertiesUtil.list((Properties)portalProperties));
        }
        return this._cacheManagerPeerProviderFactory.createCachePeerProvider(cacheManager, portalProperties);
    }
}

