/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.chars;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.booleans.BooleanArrays;
import it.unimi.dsi.fastutil.bytes.AbstractByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteCollection;
import it.unimi.dsi.fastutil.bytes.ByteIterator;
import it.unimi.dsi.fastutil.bytes.ByteListIterator;
import it.unimi.dsi.fastutil.chars.AbstractChar2ByteMap;
import it.unimi.dsi.fastutil.chars.AbstractChar2ByteSortedMap;
import it.unimi.dsi.fastutil.chars.AbstractCharSortedSet;
import it.unimi.dsi.fastutil.chars.Char2ByteMap;
import it.unimi.dsi.fastutil.chars.Char2ByteSortedMap;
import it.unimi.dsi.fastutil.chars.CharComparator;
import it.unimi.dsi.fastutil.chars.CharListIterator;
import it.unimi.dsi.fastutil.chars.CharSortedSet;
import it.unimi.dsi.fastutil.objects.AbstractObjectSortedSet;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import it.unimi.dsi.fastutil.objects.ObjectSortedSet;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;

public class Char2ByteLinkedOpenHashMap
extends AbstractChar2ByteSortedMap
implements Serializable,
Cloneable,
Hash {
    private static final long serialVersionUID = 0L;
    private static final boolean ASSERTS = false;
    protected transient char[] key;
    protected transient byte[] value;
    protected transient boolean[] used;
    protected final float f;
    protected transient int n;
    protected transient int maxFill;
    protected transient int mask;
    protected int size;
    protected volatile transient Char2ByteSortedMap.FastSortedEntrySet entries;
    protected volatile transient CharSortedSet keys;
    protected volatile transient ByteCollection values;
    protected transient int first = -1;
    protected transient int last = -1;
    protected transient long[] link;

    public Char2ByteLinkedOpenHashMap(int expected, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("Load factor must be greater than 0 and smaller than or equal to 1");
        }
        if (expected < 0) {
            throw new IllegalArgumentException("The expected number of elements must be nonnegative");
        }
        this.f = f;
        this.n = HashCommon.arraySize(expected, f);
        this.mask = this.n - 1;
        this.maxFill = HashCommon.maxFill(this.n, f);
        this.key = new char[this.n];
        this.value = new byte[this.n];
        this.used = new boolean[this.n];
        this.link = new long[this.n];
    }

    public Char2ByteLinkedOpenHashMap(int expected) {
        this(expected, 0.75f);
    }

    public Char2ByteLinkedOpenHashMap() {
        this(16, 0.75f);
    }

    public Char2ByteLinkedOpenHashMap(Map<? extends Character, ? extends Byte> m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2ByteLinkedOpenHashMap(Map<? extends Character, ? extends Byte> m) {
        this(m, 0.75f);
    }

    public Char2ByteLinkedOpenHashMap(Char2ByteMap m, float f) {
        this(m.size(), f);
        this.putAll(m);
    }

    public Char2ByteLinkedOpenHashMap(Char2ByteMap m) {
        this(m, 0.75f);
    }

    public Char2ByteLinkedOpenHashMap(char[] k, byte[] v, float f) {
        this(k.length, f);
        if (k.length != v.length) {
            throw new IllegalArgumentException("The key array and the value array have different lengths (" + k.length + " and " + v.length + ")");
        }
        for (int i = 0; i < k.length; ++i) {
            this.put(k[i], v[i]);
        }
    }

    public Char2ByteLinkedOpenHashMap(char[] k, byte[] v) {
        this(k, v, 0.75f);
    }

    @Override
    public byte put(char k, byte v) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    @Override
    public Byte put(Character ok, Byte ov) {
        byte v = ov;
        char k = ok.charValue();
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                Byte oldValue = this.value[pos];
                this.value[pos] = v;
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return null;
    }

    @Deprecated
    public byte add(char k, byte incr) {
        return this.addTo(k, incr);
    }

    public byte addTo(char k, byte incr) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                byte oldValue = this.value[pos];
                int n = pos;
                this.value[n] = (byte)(this.value[n] + incr);
                return oldValue;
            }
            pos = pos + 1 & this.mask;
        }
        this.used[pos] = true;
        this.key[pos] = k;
        this.value[pos] = (byte)(this.defRetValue + incr);
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size + 1, this.f));
        }
        return this.defRetValue;
    }

    protected final int shiftKeys(int pos) {
        int last;
        while (true) {
            last = pos;
            pos = last + 1 & this.mask;
            while (this.used[pos]) {
                int slot = HashCommon.murmurHash3(this.key[pos] ^ this.mask) & this.mask;
                if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                pos = pos + 1 & this.mask;
            }
            if (!this.used[pos]) break;
            this.key[last] = this.key[pos];
            this.value[last] = this.value[pos];
            this.fixPointers(pos, last);
        }
        this.used[last] = false;
        return last;
    }

    @Override
    public byte remove(char k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public Byte remove(Object ok) {
        char k = ((Character)ok).charValue();
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                --this.size;
                this.fixPointers(pos);
                byte v = this.value[pos];
                this.shiftKeys(pos);
                return v;
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    public byte removeFirstByte() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.first;
        this.first = (int)this.link[pos];
        if (0 <= this.first) {
            int n = this.first;
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        }
        byte v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    public byte removeLastByte() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        --this.size;
        int pos = this.last;
        this.last = (int)(this.link[pos] >>> 32);
        if (0 <= this.last) {
            int n = this.last;
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        }
        byte v = this.value[pos];
        this.shiftKeys(pos);
        return v;
    }

    private void moveIndexToFirst(int i) {
        if (this.size == 1 || this.first == i) {
            return;
        }
        if (this.last == i) {
            int n = this.last = (int)(this.link[i] >>> 32);
            this.link[n] = this.link[n] | 0xFFFFFFFFL;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.first;
        this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)i & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[i] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
        this.first = i;
    }

    private void moveIndexToLast(int i) {
        if (this.size == 1 || this.last == i) {
            return;
        }
        if (this.first == i) {
            int n = this.first = (int)this.link[i];
            this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
        } else {
            long linki = this.link[i];
            int prev = (int)(linki >>> 32);
            int next = (int)linki;
            int n = prev;
            this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            int n2 = next;
            this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
        }
        int n = this.last;
        this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)i & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        this.link[i] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
        this.last = i;
    }

    public byte getAndMoveToFirst(char k) {
        char[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                this.moveIndexToFirst(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public byte getAndMoveToLast(char k) {
        char[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                this.moveIndexToLast(pos);
                return this.value[pos];
            }
            pos = pos + 1 & mask;
        }
        return this.defRetValue;
    }

    public byte putAndMoveToFirst(char k, byte v) {
        char[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToFirst(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.first;
            this.link[n] = this.link[n] ^ (this.link[this.first] ^ ((long)pos & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[pos] = 0xFFFFFFFF00000000L | (long)this.first & 0xFFFFFFFFL;
            this.first = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public byte putAndMoveToLast(char k, byte v) {
        char[] key = this.key;
        boolean[] used = this.used;
        int mask = this.mask;
        int pos = HashCommon.murmurHash3(k ^ mask) & mask;
        while (used[pos]) {
            if (k == key[pos]) {
                byte oldValue = this.value[pos];
                this.value[pos] = v;
                this.moveIndexToLast(pos);
                return oldValue;
            }
            pos = pos + 1 & mask;
        }
        used[pos] = true;
        key[pos] = k;
        this.value[pos] = v;
        if (this.size == 0) {
            this.first = this.last = pos;
            this.link[pos] = -1L;
        } else {
            int n = this.last;
            this.link[n] = this.link[n] ^ (this.link[this.last] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[pos] = ((long)this.last & 0xFFFFFFFFL) << 32 | 0xFFFFFFFFL;
            this.last = pos;
        }
        if (++this.size >= this.maxFill) {
            this.rehash(HashCommon.arraySize(this.size, this.f));
        }
        return this.defRetValue;
    }

    public Byte get(Character ok) {
        char k = ok.charValue();
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return null;
    }

    @Override
    public byte get(char k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return this.value[pos];
            }
            pos = pos + 1 & this.mask;
        }
        return this.defRetValue;
    }

    @Override
    public boolean containsKey(char k) {
        int pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
        while (this.used[pos]) {
            if (this.key[pos] == k) {
                return true;
            }
            pos = pos + 1 & this.mask;
        }
        return false;
    }

    @Override
    public boolean containsValue(byte v) {
        byte[] value = this.value;
        boolean[] used = this.used;
        int i = this.n;
        while (i-- != 0) {
            if (!used[i] || value[i] != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        BooleanArrays.fill(this.used, false);
        this.last = -1;
        this.first = -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Deprecated
    public void growthFactor(int growthFactor) {
    }

    @Deprecated
    public int growthFactor() {
        return 16;
    }

    protected void fixPointers(int i) {
        if (this.size == 0) {
            this.last = -1;
            this.first = -1;
            return;
        }
        if (this.first == i) {
            this.first = (int)this.link[i];
            if (0 <= this.first) {
                int n = this.first;
                this.link[n] = this.link[n] | 0xFFFFFFFF00000000L;
            }
            return;
        }
        if (this.last == i) {
            this.last = (int)(this.link[i] >>> 32);
            if (0 <= this.last) {
                int n = this.last;
                this.link[n] = this.link[n] | 0xFFFFFFFFL;
            }
            return;
        }
        long linki = this.link[i];
        int prev = (int)(linki >>> 32);
        int next = (int)linki;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ linki & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ linki & 0xFFFFFFFF00000000L) & 0xFFFFFFFF00000000L;
    }

    protected void fixPointers(int s, int d) {
        if (this.size == 1) {
            this.first = this.last = d;
            this.link[d] = -1L;
            return;
        }
        if (this.first == s) {
            this.first = d;
            int n = (int)this.link[s];
            this.link[n] = this.link[n] ^ (this.link[(int)this.link[s]] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            this.link[d] = this.link[s];
            return;
        }
        if (this.last == s) {
            this.last = d;
            int n = (int)(this.link[s] >>> 32);
            this.link[n] = this.link[n] ^ (this.link[(int)(this.link[s] >>> 32)] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            this.link[d] = this.link[s];
            return;
        }
        long links = this.link[s];
        int prev = (int)(links >>> 32);
        int next = (int)links;
        int n = prev;
        this.link[n] = this.link[n] ^ (this.link[prev] ^ (long)d & 0xFFFFFFFFL) & 0xFFFFFFFFL;
        int n2 = next;
        this.link[n2] = this.link[n2] ^ (this.link[next] ^ ((long)d & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
        this.link[d] = links;
    }

    @Override
    public char firstCharKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.first];
    }

    @Override
    public char lastCharKey() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.key[this.last];
    }

    @Override
    public CharComparator comparator() {
        return null;
    }

    @Override
    public Char2ByteSortedMap tailMap(char from) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Char2ByteSortedMap headMap(char to) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Char2ByteSortedMap subMap(char from, char to) {
        throw new UnsupportedOperationException();
    }

    public Char2ByteSortedMap.FastSortedEntrySet char2ByteEntrySet() {
        if (this.entries == null) {
            this.entries = new MapEntrySet();
        }
        return this.entries;
    }

    @Override
    public CharSortedSet keySet() {
        if (this.keys == null) {
            this.keys = new KeySet();
        }
        return this.keys;
    }

    @Override
    public ByteCollection values() {
        if (this.values == null) {
            this.values = new AbstractByteCollection(){

                @Override
                public ByteIterator iterator() {
                    return new ValueIterator();
                }

                @Override
                public int size() {
                    return Char2ByteLinkedOpenHashMap.this.size;
                }

                @Override
                public boolean contains(byte v) {
                    return Char2ByteLinkedOpenHashMap.this.containsValue(v);
                }

                @Override
                public void clear() {
                    Char2ByteLinkedOpenHashMap.this.clear();
                }
            };
        }
        return this.values;
    }

    @Deprecated
    public boolean rehash() {
        return true;
    }

    public boolean trim() {
        int l = HashCommon.arraySize(this.size, this.f);
        if (l >= this.n) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    public boolean trim(int n) {
        int l = HashCommon.nextPowerOfTwo((int)Math.ceil((float)n / this.f));
        if (this.n <= l) {
            return true;
        }
        try {
            this.rehash(l);
        }
        catch (OutOfMemoryError cantDoIt) {
            return false;
        }
        return true;
    }

    protected void rehash(int newN) {
        int i = this.first;
        int prev = -1;
        int newPrev = -1;
        char[] key = this.key;
        byte[] value = this.value;
        int mask = newN - 1;
        char[] newKey = new char[newN];
        byte[] newValue = new byte[newN];
        boolean[] newUsed = new boolean[newN];
        long[] link = this.link;
        long[] newLink = new long[newN];
        this.first = -1;
        int j = this.size;
        while (j-- != 0) {
            char k = key[i];
            int pos = HashCommon.murmurHash3(k ^ mask) & mask;
            while (newUsed[pos]) {
                pos = pos + 1 & mask;
            }
            newUsed[pos] = true;
            newKey[pos] = k;
            newValue[pos] = value[i];
            if (prev != -1) {
                int n = newPrev;
                newLink[n] = newLink[n] ^ (newLink[newPrev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                newLink[n2] = newLink[n2] ^ (newLink[pos] ^ ((long)newPrev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                newPrev = pos;
            } else {
                newPrev = this.first = pos;
                newLink[pos] = -1L;
            }
            int t = i;
            i = (int)link[i];
            prev = t;
        }
        this.n = newN;
        this.mask = mask;
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.key = newKey;
        this.value = newValue;
        this.used = newUsed;
        this.link = newLink;
        this.last = newPrev;
        if (newPrev != -1) {
            int n = newPrev;
            newLink[n] = newLink[n] | 0xFFFFFFFFL;
        }
    }

    public Char2ByteLinkedOpenHashMap clone() {
        Char2ByteLinkedOpenHashMap c;
        try {
            c = (Char2ByteLinkedOpenHashMap)super.clone();
        }
        catch (CloneNotSupportedException cantHappen) {
            throw new InternalError();
        }
        c.keys = null;
        c.values = null;
        c.entries = null;
        c.key = (char[])this.key.clone();
        c.value = (byte[])this.value.clone();
        c.used = (boolean[])this.used.clone();
        c.link = (long[])this.link.clone();
        return c;
    }

    @Override
    public int hashCode() {
        int h = 0;
        int j = this.size;
        int i = 0;
        int t = 0;
        while (j-- != 0) {
            while (!this.used[i]) {
                ++i;
            }
            t = this.key[i];
            h += (t ^= this.value[i]);
            ++i;
        }
        return h;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        char[] key = this.key;
        byte[] value = this.value;
        MapIterator i = new MapIterator();
        s.defaultWriteObject();
        int j = this.size;
        while (j-- != 0) {
            int e = i.nextEntry();
            s.writeChar(key[e]);
            s.writeByte(value[e]);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.n = HashCommon.arraySize(this.size, this.f);
        this.maxFill = HashCommon.maxFill(this.n, this.f);
        this.mask = this.n - 1;
        this.key = new char[this.n];
        char[] key = this.key;
        this.value = new byte[this.n];
        byte[] value = this.value;
        this.used = new boolean[this.n];
        boolean[] used = this.used;
        this.link = new long[this.n];
        long[] link = this.link;
        int prev = -1;
        this.last = -1;
        this.first = -1;
        int i = this.size;
        int pos = 0;
        while (i-- != 0) {
            char k = s.readChar();
            byte v = s.readByte();
            pos = HashCommon.murmurHash3(k ^ this.mask) & this.mask;
            while (used[pos]) {
                pos = pos + 1 & this.mask;
            }
            used[pos] = true;
            key[pos] = k;
            value[pos] = v;
            if (this.first != -1) {
                int n = prev;
                link[n] = link[n] ^ (link[prev] ^ (long)pos & 0xFFFFFFFFL) & 0xFFFFFFFFL;
                int n2 = pos;
                link[n2] = link[n2] ^ (link[pos] ^ ((long)prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
                prev = pos;
                continue;
            }
            prev = this.first = pos;
            int n = pos;
            link[n] = link[n] | 0xFFFFFFFF00000000L;
        }
        this.last = prev;
        if (prev != -1) {
            int n = prev;
            link[n] = link[n] | 0xFFFFFFFFL;
        }
    }

    private void checkTable() {
    }

    private final class ValueIterator
    extends MapIterator
    implements ByteListIterator {
        @Override
        public byte previousByte() {
            return Char2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public Byte previous() {
            return Char2ByteLinkedOpenHashMap.this.value[this.previousEntry()];
        }

        @Override
        public void set(Byte ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Byte ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(byte v) {
            throw new UnsupportedOperationException();
        }

        @Override
        public byte nextByte() {
            return Char2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }

        @Override
        public Byte next() {
            return Char2ByteLinkedOpenHashMap.this.value[this.nextEntry()];
        }
    }

    private final class KeySet
    extends AbstractCharSortedSet {
        private KeySet() {
        }

        @Override
        public CharListIterator iterator(char from) {
            return new KeyIterator(from);
        }

        @Override
        public CharListIterator iterator() {
            return new KeyIterator();
        }

        @Override
        public int size() {
            return Char2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public boolean contains(char k) {
            return Char2ByteLinkedOpenHashMap.this.containsKey(k);
        }

        @Override
        public boolean remove(char k) {
            int oldSize = Char2ByteLinkedOpenHashMap.this.size;
            Char2ByteLinkedOpenHashMap.this.remove(k);
            return Char2ByteLinkedOpenHashMap.this.size != oldSize;
        }

        @Override
        public void clear() {
            Char2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public char firstChar() {
            if (Char2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Char2ByteLinkedOpenHashMap.this.key[Char2ByteLinkedOpenHashMap.this.first];
        }

        @Override
        public char lastChar() {
            if (Char2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return Char2ByteLinkedOpenHashMap.this.key[Char2ByteLinkedOpenHashMap.this.last];
        }

        @Override
        public CharComparator comparator() {
            return null;
        }

        @Override
        public final CharSortedSet tailSet(char from) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final CharSortedSet headSet(char to) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final CharSortedSet subSet(char from, char to) {
            throw new UnsupportedOperationException();
        }
    }

    private final class KeyIterator
    extends MapIterator
    implements CharListIterator {
        public KeyIterator(char k) {
            super(k);
        }

        @Override
        public char previousChar() {
            return Char2ByteLinkedOpenHashMap.this.key[this.previousEntry()];
        }

        @Override
        public void set(char k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(char k) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Character previous() {
            return Character.valueOf(Char2ByteLinkedOpenHashMap.this.key[this.previousEntry()]);
        }

        @Override
        public void set(Character ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Character ok) {
            throw new UnsupportedOperationException();
        }

        public KeyIterator() {
        }

        @Override
        public char nextChar() {
            return Char2ByteLinkedOpenHashMap.this.key[this.nextEntry()];
        }

        @Override
        public Character next() {
            return Character.valueOf(Char2ByteLinkedOpenHashMap.this.key[this.nextEntry()]);
        }
    }

    private final class MapEntrySet
    extends AbstractObjectSortedSet<Char2ByteMap.Entry>
    implements Char2ByteSortedMap.FastSortedEntrySet {
        private MapEntrySet() {
        }

        @Override
        public ObjectBidirectionalIterator<Char2ByteMap.Entry> iterator() {
            return new EntryIterator();
        }

        @Override
        public Comparator<? super Char2ByteMap.Entry> comparator() {
            return null;
        }

        @Override
        public ObjectSortedSet<Char2ByteMap.Entry> subSet(Char2ByteMap.Entry fromElement, Char2ByteMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Char2ByteMap.Entry> headSet(Char2ByteMap.Entry toElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ObjectSortedSet<Char2ByteMap.Entry> tailSet(Char2ByteMap.Entry fromElement) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Char2ByteMap.Entry first() {
            if (Char2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Char2ByteLinkedOpenHashMap.this.first);
        }

        @Override
        public Char2ByteMap.Entry last() {
            if (Char2ByteLinkedOpenHashMap.this.size == 0) {
                throw new NoSuchElementException();
            }
            return new MapEntry(Char2ByteLinkedOpenHashMap.this.last);
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            char k = ((Character)e.getKey()).charValue();
            int pos = HashCommon.murmurHash3(k ^ Char2ByteLinkedOpenHashMap.this.mask) & Char2ByteLinkedOpenHashMap.this.mask;
            while (Char2ByteLinkedOpenHashMap.this.used[pos]) {
                if (Char2ByteLinkedOpenHashMap.this.key[pos] == k) {
                    return Char2ByteLinkedOpenHashMap.this.value[pos] == (Byte)e.getValue();
                }
                pos = pos + 1 & Char2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            char k = ((Character)e.getKey()).charValue();
            int pos = HashCommon.murmurHash3(k ^ Char2ByteLinkedOpenHashMap.this.mask) & Char2ByteLinkedOpenHashMap.this.mask;
            while (Char2ByteLinkedOpenHashMap.this.used[pos]) {
                if (Char2ByteLinkedOpenHashMap.this.key[pos] == k) {
                    Char2ByteLinkedOpenHashMap.this.remove(e.getKey());
                    return true;
                }
                pos = pos + 1 & Char2ByteLinkedOpenHashMap.this.mask;
            }
            return false;
        }

        @Override
        public int size() {
            return Char2ByteLinkedOpenHashMap.this.size;
        }

        @Override
        public void clear() {
            Char2ByteLinkedOpenHashMap.this.clear();
        }

        @Override
        public ObjectBidirectionalIterator<Char2ByteMap.Entry> iterator(Char2ByteMap.Entry from) {
            return new EntryIterator(((Character)from.getKey()).charValue());
        }

        public ObjectBidirectionalIterator<Char2ByteMap.Entry> fastIterator() {
            return new FastEntryIterator();
        }

        @Override
        public ObjectBidirectionalIterator<Char2ByteMap.Entry> fastIterator(Char2ByteMap.Entry from) {
            return new FastEntryIterator(((Character)from.getKey()).charValue());
        }
    }

    private class FastEntryIterator
    extends MapIterator
    implements ObjectListIterator<Char2ByteMap.Entry> {
        final AbstractChar2ByteMap.BasicEntry entry;

        public FastEntryIterator() {
            this.entry = new AbstractChar2ByteMap.BasicEntry('\u0000', 0);
        }

        public FastEntryIterator(char from) {
            super(from);
            this.entry = new AbstractChar2ByteMap.BasicEntry('\u0000', 0);
        }

        @Override
        public AbstractChar2ByteMap.BasicEntry next() {
            int e = this.nextEntry();
            this.entry.key = Char2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Char2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public AbstractChar2ByteMap.BasicEntry previous() {
            int e = this.previousEntry();
            this.entry.key = Char2ByteLinkedOpenHashMap.this.key[e];
            this.entry.value = Char2ByteLinkedOpenHashMap.this.value[e];
            return this.entry;
        }

        @Override
        public void set(Char2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Char2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class EntryIterator
    extends MapIterator
    implements ObjectListIterator<Char2ByteMap.Entry> {
        private MapEntry entry;

        public EntryIterator() {
        }

        public EntryIterator(char from) {
            super(from);
        }

        @Override
        public MapEntry next() {
            this.entry = new MapEntry(this.nextEntry());
            return this.entry;
        }

        @Override
        public MapEntry previous() {
            this.entry = new MapEntry(this.previousEntry());
            return this.entry;
        }

        @Override
        public void remove() {
            super.remove();
            this.entry.index = -1;
        }

        @Override
        public void set(Char2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Char2ByteMap.Entry ok) {
            throw new UnsupportedOperationException();
        }
    }

    private class MapIterator {
        int prev = -1;
        int next = -1;
        int curr = -1;
        int index = -1;

        private MapIterator() {
            this.next = Char2ByteLinkedOpenHashMap.this.first;
            this.index = 0;
        }

        private MapIterator(char from) {
            if (Char2ByteLinkedOpenHashMap.this.key[Char2ByteLinkedOpenHashMap.this.last] != from) {
                int pos = HashCommon.murmurHash3(from ^ Char2ByteLinkedOpenHashMap.this.mask) & Char2ByteLinkedOpenHashMap.this.mask;
                while (Char2ByteLinkedOpenHashMap.this.used[pos]) {
                    if (Char2ByteLinkedOpenHashMap.this.key[pos] == from) {
                        this.next = (int)Char2ByteLinkedOpenHashMap.this.link[pos];
                        this.prev = pos;
                        return;
                    }
                    pos = pos + 1 & Char2ByteLinkedOpenHashMap.this.mask;
                }
                throw new NoSuchElementException("The key " + from + " does not belong to this map.");
            }
            this.prev = Char2ByteLinkedOpenHashMap.this.last;
            this.index = Char2ByteLinkedOpenHashMap.this.size;
        }

        public boolean hasNext() {
            return this.next != -1;
        }

        public boolean hasPrevious() {
            return this.prev != -1;
        }

        private final void ensureIndexKnown() {
            if (this.index >= 0) {
                return;
            }
            if (this.prev == -1) {
                this.index = 0;
                return;
            }
            if (this.next == -1) {
                this.index = Char2ByteLinkedOpenHashMap.this.size;
                return;
            }
            int pos = Char2ByteLinkedOpenHashMap.this.first;
            this.index = 1;
            while (pos != this.prev) {
                pos = (int)Char2ByteLinkedOpenHashMap.this.link[pos];
                ++this.index;
            }
        }

        public int nextIndex() {
            this.ensureIndexKnown();
            return this.index;
        }

        public int previousIndex() {
            this.ensureIndexKnown();
            return this.index - 1;
        }

        public int nextEntry() {
            if (!this.hasNext()) {
                return Char2ByteLinkedOpenHashMap.this.size();
            }
            this.curr = this.next;
            this.next = (int)Char2ByteLinkedOpenHashMap.this.link[this.curr];
            this.prev = this.curr;
            if (this.index >= 0) {
                ++this.index;
            }
            return this.curr;
        }

        public int previousEntry() {
            if (!this.hasPrevious()) {
                return -1;
            }
            this.curr = this.prev;
            this.prev = (int)(Char2ByteLinkedOpenHashMap.this.link[this.curr] >>> 32);
            this.next = this.curr;
            if (this.index >= 0) {
                --this.index;
            }
            return this.curr;
        }

        public void remove() {
            this.ensureIndexKnown();
            if (this.curr == -1) {
                throw new IllegalStateException();
            }
            if (this.curr == this.prev) {
                --this.index;
                this.prev = (int)(Char2ByteLinkedOpenHashMap.this.link[this.curr] >>> 32);
            } else {
                this.next = (int)Char2ByteLinkedOpenHashMap.this.link[this.curr];
            }
            --Char2ByteLinkedOpenHashMap.this.size;
            if (this.prev == -1) {
                Char2ByteLinkedOpenHashMap.this.first = this.next;
            } else {
                int n = this.prev;
                Char2ByteLinkedOpenHashMap.this.link[n] = Char2ByteLinkedOpenHashMap.this.link[n] ^ (Char2ByteLinkedOpenHashMap.this.link[this.prev] ^ (long)this.next & 0xFFFFFFFFL) & 0xFFFFFFFFL;
            }
            if (this.next == -1) {
                Char2ByteLinkedOpenHashMap.this.last = this.prev;
            } else {
                int n = this.next;
                Char2ByteLinkedOpenHashMap.this.link[n] = Char2ByteLinkedOpenHashMap.this.link[n] ^ (Char2ByteLinkedOpenHashMap.this.link[this.next] ^ ((long)this.prev & 0xFFFFFFFFL) << 32) & 0xFFFFFFFF00000000L;
            }
            int pos = this.curr;
            while (true) {
                int last = pos;
                pos = last + 1 & Char2ByteLinkedOpenHashMap.this.mask;
                while (Char2ByteLinkedOpenHashMap.this.used[pos]) {
                    int slot = HashCommon.murmurHash3(Char2ByteLinkedOpenHashMap.this.key[pos] ^ Char2ByteLinkedOpenHashMap.this.mask) & Char2ByteLinkedOpenHashMap.this.mask;
                    if (last <= pos ? last >= slot || slot > pos : last >= slot && slot > pos) break;
                    pos = pos + 1 & Char2ByteLinkedOpenHashMap.this.mask;
                }
                if (!Char2ByteLinkedOpenHashMap.this.used[pos]) break;
                Char2ByteLinkedOpenHashMap.this.key[last] = Char2ByteLinkedOpenHashMap.this.key[pos];
                Char2ByteLinkedOpenHashMap.this.value[last] = Char2ByteLinkedOpenHashMap.this.value[pos];
                if (this.next == pos) {
                    this.next = last;
                }
                if (this.prev == pos) {
                    this.prev = last;
                }
                Char2ByteLinkedOpenHashMap.this.fixPointers(pos, last);
            }
            Char2ByteLinkedOpenHashMap.this.used[last] = false;
            this.curr = -1;
        }

        public int skip(int n) {
            int i = n;
            while (i-- != 0 && this.hasNext()) {
                this.nextEntry();
            }
            return n - i - 1;
        }

        public int back(int n) {
            int i = n;
            while (i-- != 0 && this.hasPrevious()) {
                this.previousEntry();
            }
            return n - i - 1;
        }
    }

    private final class MapEntry
    implements Char2ByteMap.Entry,
    Map.Entry<Character, Byte> {
        private int index;

        MapEntry(int index) {
            this.index = index;
        }

        @Override
        public Character getKey() {
            return Character.valueOf(Char2ByteLinkedOpenHashMap.this.key[this.index]);
        }

        @Override
        public char getCharKey() {
            return Char2ByteLinkedOpenHashMap.this.key[this.index];
        }

        @Override
        public Byte getValue() {
            return Char2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte getByteValue() {
            return Char2ByteLinkedOpenHashMap.this.value[this.index];
        }

        @Override
        public byte setValue(byte v) {
            byte oldValue = Char2ByteLinkedOpenHashMap.this.value[this.index];
            Char2ByteLinkedOpenHashMap.this.value[this.index] = v;
            return oldValue;
        }

        @Override
        public Byte setValue(Byte v) {
            return this.setValue((byte)v);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return Char2ByteLinkedOpenHashMap.this.key[this.index] == ((Character)e.getKey()).charValue() && Char2ByteLinkedOpenHashMap.this.value[this.index] == (Byte)e.getValue();
        }

        @Override
        public int hashCode() {
            return Char2ByteLinkedOpenHashMap.this.key[this.index] ^ Char2ByteLinkedOpenHashMap.this.value[this.index];
        }

        public String toString() {
            return Char2ByteLinkedOpenHashMap.this.key[this.index] + "=>" + Char2ByteLinkedOpenHashMap.this.value[this.index];
        }
    }
}

