/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutSet;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.base.MDRRuleGroupInstanceServiceBaseImpl;
import com.liferay.portlet.mobiledevicerules.service.permission.MDRPermissionUtil;
import com.liferay.portlet.mobiledevicerules.service.permission.MDRRuleGroupInstancePermissionUtil;
import java.util.List;

public class MDRRuleGroupInstanceServiceImpl
extends MDRRuleGroupInstanceServiceBaseImpl {
    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, int priority, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ADD_RULE_GROUP_INSTANCE");
        return this.mdrRuleGroupInstanceLocalService.addRuleGroupInstance(groupId, className, classPK, ruleGroupId, priority, serviceContext);
    }

    public MDRRuleGroupInstance addRuleGroupInstance(long groupId, String className, long classPK, long ruleGroupId, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"ADD_RULE_GROUP_INSTANCE");
        return this.mdrRuleGroupInstanceLocalService.addRuleGroupInstance(groupId, className, classPK, ruleGroupId, serviceContext);
    }

    public void deleteRuleGroupInstance(long ruleGroupInstanceId) throws PortalException, SystemException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (MDRRuleGroupInstance)ruleGroupInstance, (String)"DELETE");
        this.mdrRuleGroupInstanceLocalService.deleteRuleGroupInstance(ruleGroupInstance);
    }

    public List<MDRRuleGroupInstance> getRuleGroupInstances(String className, long classPK, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        long groupId = this.getGroupId(className, classPK);
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.filterFindByG_C_C(groupId, classNameId, classPK, start, end, orderByComparator);
    }

    public int getRuleGroupInstancesCount(String className, long classPK) throws SystemException {
        long groupId = this.getGroupId(className, classPK);
        long classNameId = PortalUtil.getClassNameId((String)className);
        return this.mdrRuleGroupInstancePersistence.filterCountByG_C_C(groupId, classNameId, classPK);
    }

    public MDRRuleGroupInstance updateRuleGroupInstance(long ruleGroupInstanceId, int priority) throws PortalException, SystemException {
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        MDRRuleGroupInstancePermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (long)ruleGroupInstance.getRuleGroupInstanceId(), (String)"UPDATE");
        return this.mdrRuleGroupInstanceLocalService.updateRuleGroupInstance(ruleGroupInstanceId, priority);
    }

    protected long getGroupId(String className, long classPK) throws SystemException {
        LayoutSet layoutSet;
        long groupId = 0L;
        if (className.equals(Layout.class.getName())) {
            Layout layout = this.layoutPersistence.fetchByPrimaryKey(classPK);
            if (layout != null) {
                groupId = layout.getGroupId();
            }
        } else if (className.equals(LayoutSet.class.getName()) && (layoutSet = this.layoutSetPersistence.fetchByPrimaryKey(classPK)) != null) {
            groupId = layoutSet.getGroupId();
        }
        return groupId;
    }
}

