/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.model.Layout;
import com.liferay.portal.model.LayoutFriendlyURL;
import com.liferay.portal.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.service.LayoutLocalServiceUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.util.List;

public class VerifyLayout
extends VerifyProcess {
    @Override
    protected void doVerify() throws Exception {
        this.verifyFriendlyURL();
        this.verifyUuid();
    }

    protected void verifyFriendlyURL() throws Exception {
        List layouts = LayoutLocalServiceUtil.getNullFriendlyURLLayouts();
        for (Layout layout : layouts) {
            List layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs((long)layout.getPlid());
            for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                String friendlyURL = "/" + layout.getLayoutId();
                LayoutLocalServiceUtil.updateFriendlyURL((long)layout.getPlid(), (String)friendlyURL, (String)layoutFriendlyURL.getLanguageId());
            }
        }
    }

    protected void verifyUuid() throws Exception {
        this.verifyUuid("AssetEntry");
        this.verifyUuid("JournalArticle");
        StringBundler sb = new StringBundler(3);
        sb.append("update Layout set uuid_ = sourcePrototypeLayoutUuid where ");
        sb.append("sourcePrototypeLayoutUuid != '' and ");
        sb.append("uuid_ != sourcePrototypeLayoutUuid");
        this.runSQL(sb.toString());
    }

    protected void verifyUuid(String tableName) throws Exception {
        StringBundler sb = new StringBundler(12);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set layoutUuid = (select distinct ");
        sb.append("sourcePrototypeLayoutUuid from Layout where ");
        sb.append("Layout.uuid_ = ");
        sb.append(tableName);
        sb.append(".layoutUuid) where exists (select 1 from Layout where ");
        sb.append("Layout.uuid_ = ");
        sb.append(tableName);
        sb.append(".layoutUuid and Layout.uuid_ != ");
        sb.append("Layout.sourcePrototypeLayoutUuid and ");
        sb.append("Layout.sourcePrototypeLayoutUuid != '')");
        this.runSQL(sb.toString());
    }
}

