/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.json.jabsorb.serializer;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Iterator;
import org.jabsorb.JSONSerializer;
import org.jabsorb.serializer.AbstractSerializer;
import org.jabsorb.serializer.MarshallException;
import org.jabsorb.serializer.ObjectMatch;
import org.jabsorb.serializer.SerializerState;
import org.jabsorb.serializer.UnmarshallException;
import org.json.JSONObject;

public class LiferaySerializer
extends AbstractSerializer {
    private static final Class<?>[] _JSON_CLASSES = new Class[]{JSONObject.class};
    private static final Class<?>[] _SERIALIZABLE_CLASSES = new Class[]{Serializable.class};
    private static Log _log = LogFactoryUtil.getLog(LiferaySerializer.class);

    public boolean canSerialize(Class clazz, Class jsonClass) {
        Constructor constructor = null;
        try {
            constructor = clazz.getConstructor(new Class[0]);
        }
        catch (Exception exception) {}
        return Serializable.class.isAssignableFrom(clazz) && (jsonClass == null || jsonClass == JSONObject.class) && constructor != null;
    }

    public Class<?>[] getJSONClasses() {
        return _JSON_CLASSES;
    }

    public Class<?>[] getSerializableClasses() {
        return _SERIALIZABLE_CLASSES;
    }

    public Object marshall(SerializerState serializerState, Object parentObject, Object object) throws MarshallException {
        JSONObject jsonObject = new JSONObject();
        Class<?> javaClass = object.getClass();
        if (this.ser.getMarshallClassHints()) {
            try {
                jsonObject.put("javaClass", (Object)javaClass.getName());
            }
            catch (Exception e2) {
                throw new MarshallException("Unable to put javaClass", (Throwable)e2);
            }
        }
        JSONObject serializableJSONObject = new JSONObject();
        try {
            jsonObject.put("serializable", (Object)serializableJSONObject);
            serializerState.push(object, (Object)serializableJSONObject, (Object)"serializable");
        }
        catch (Exception e3) {
            throw new MarshallException("Unable to put serializable", (Throwable)e3);
        }
        String fieldName = null;
        try {
            try {
                HashSet<String> processedFieldNames = new HashSet<String>();
                while (javaClass != null) {
                    Field[] declaredFields;
                    Field[] fieldArray = declaredFields = javaClass.getDeclaredFields();
                    int n = declaredFields.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Field field = fieldArray[n2];
                        fieldName = field.getName();
                        if (!processedFieldNames.contains(fieldName)) {
                            processedFieldNames.add(fieldName);
                            int modifiers = field.getModifiers();
                            if ((modifiers & 0x10) != 16 && (modifiers & 8) != 8 && (modifiers & 0x80) != 128) {
                                Object fieldObject;
                                if (!field.isAccessible()) {
                                    field.setAccessible(true);
                                }
                                if (fieldName.startsWith("_")) {
                                    fieldName = fieldName.substring(1);
                                }
                                if (JSONSerializer.CIRC_REF_OR_DUPLICATE != (fieldObject = this.ser.marshall(serializerState, (Object)serializableJSONObject, field.get(object), (Object)fieldName))) {
                                    serializableJSONObject.put(fieldName, fieldObject);
                                }
                            }
                        }
                        ++n2;
                    }
                    javaClass = javaClass.getSuperclass();
                }
            }
            catch (Exception e4) {
                throw new MarshallException("Unable to match field " + fieldName, (Throwable)e4);
            }
        }
        finally {
            serializerState.pop();
        }
        return jsonObject;
    }

    public ObjectMatch tryUnmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        String javaClassName = null;
        try {
            javaClassName = jsonObject.getString("javaClass");
        }
        catch (Exception e2) {
            throw new UnmarshallException("Unable to get javaClass", (Throwable)e2);
        }
        if (javaClassName == null) {
            throw new UnmarshallException("javaClass is undefined");
        }
        try {
            Class<?> javaClass = Class.forName(javaClassName);
            Serializable.class.isAssignableFrom(javaClass);
        }
        catch (Exception e3) {
            throw new UnmarshallException("Unable to load javaClass " + javaClassName, (Throwable)e3);
        }
        JSONObject serializableJSONObject = null;
        try {
            serializableJSONObject = jsonObject.getJSONObject("serializable");
        }
        catch (Exception e4) {
            throw new UnmarshallException("Unable to get serializable", (Throwable)e4);
        }
        if (serializableJSONObject == null) {
            throw new UnmarshallException("serializable is undefined");
        }
        ObjectMatch objectMatch = new ObjectMatch(-1);
        serializerState.setSerialized(object, (Object)objectMatch);
        String fieldName = null;
        try {
            Iterator iterator = serializableJSONObject.keys();
            while (iterator.hasNext()) {
                fieldName = (String)iterator.next();
                ObjectMatch fieldObjectMatch = this.ser.tryUnmarshall(serializerState, null, serializableJSONObject.get(fieldName));
                ObjectMatch maxFieldObjectMatch = fieldObjectMatch.max(objectMatch);
                objectMatch.setMismatch(maxFieldObjectMatch.getMismatch());
            }
        }
        catch (Exception e5) {
            throw new UnmarshallException("Unable to match field " + fieldName, (Throwable)e5);
        }
        return objectMatch;
    }

    public Object unmarshall(SerializerState serializerState, Class clazz, Object object) throws UnmarshallException {
        JSONObject jsonObject = (JSONObject)object;
        String javaClassName = null;
        try {
            javaClassName = jsonObject.getString("javaClass");
        }
        catch (Exception e2) {
            throw new UnmarshallException("Unable to get javaClass", (Throwable)e2);
        }
        if (javaClassName == null) {
            throw new UnmarshallException("javaClass is undefined");
        }
        Class<?> javaClass = null;
        Object javaClassInstance = null;
        try {
            javaClass = Class.forName(javaClassName);
            javaClassInstance = javaClass.newInstance();
        }
        catch (Exception e3) {
            throw new UnmarshallException("Unable to load javaClass " + javaClassName, (Throwable)e3);
        }
        JSONObject serializableJSONObject = null;
        try {
            serializableJSONObject = jsonObject.getJSONObject("serializable");
        }
        catch (Exception e4) {
            throw new UnmarshallException("Unable to get serializable", (Throwable)e4);
        }
        if (serializableJSONObject == null) {
            throw new UnmarshallException("serializable is undefined");
        }
        serializerState.setSerialized(object, javaClassInstance);
        String fieldName = null;
        try {
            HashSet<String> processedFieldNames = new HashSet<String>();
            while (javaClass != null) {
                Field[] fields;
                Field[] fieldArray = fields = javaClass.getDeclaredFields();
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    fieldName = field.getName();
                    if (!processedFieldNames.contains(fieldName)) {
                        processedFieldNames.add(fieldName);
                        int modifiers = field.getModifiers();
                        if ((modifiers & 0x10) != 16 && (modifiers & 8) != 8 && (modifiers & 0x80) != 128) {
                            if (!field.isAccessible()) {
                                field.setAccessible(true);
                            }
                            if (fieldName.startsWith("_")) {
                                fieldName = fieldName.substring(1);
                            }
                            Object value = null;
                            try {
                                value = this.ser.unmarshall(serializerState, field.getType(), serializableJSONObject.get(fieldName));
                            }
                            catch (Exception exception) {}
                            if (value != null) {
                                try {
                                    field.set(javaClassInstance, value);
                                }
                                catch (Exception e5) {
                                    _log.error((Object)e5, (Throwable)e5);
                                }
                            }
                        }
                    }
                    ++n2;
                }
                javaClass = javaClass.getSuperclass();
            }
        }
        catch (Exception e6) {
            throw new UnmarshallException("Unable to match field " + fieldName, (Throwable)e6);
        }
        return javaClassInstance;
    }
}

