/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.cache;

import com.liferay.portal.kernel.cache.Lifecycle;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ThreadLocalCache<T> {
    private Map<String, T> _cache;
    private Lifecycle _lifecycle;
    private Serializable _name;

    public ThreadLocalCache(Serializable name, Lifecycle lifecycle) {
        this._name = name;
        this._lifecycle = lifecycle;
    }

    public T get(String key) {
        if (this._cache == null) {
            return null;
        }
        return this._cache.get(key);
    }

    public Lifecycle getLifecycle() {
        return this._lifecycle;
    }

    public Serializable getName() {
        return this._name;
    }

    public void put(String key, T obj) {
        if (this._cache == null) {
            this._cache = new HashMap<String, T>();
        }
        this._cache.put(key, obj);
    }

    public void remove(String key) {
        if (this._cache != null) {
            this._cache.remove(key);
        }
    }

    public void removeAll() {
        if (this._cache != null) {
            this._cache.clear();
        }
    }

    public String toString() {
        StringBundler sb = new StringBundler(7);
        sb.append("{cache=");
        sb.append(this._cache.toString());
        sb.append(", lifecycle=");
        sb.append((Object)this._lifecycle);
        sb.append(", name=");
        sb.append(this._name);
        sb.append("}");
        return sb.toString();
    }
}

