/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.mesa.rdf.jena.common.regression;

import com.hp.hpl.mesa.rdf.jena.common.ErrorHelper;
import com.hp.hpl.mesa.rdf.jena.common.SelectorImpl;
import com.hp.hpl.mesa.rdf.jena.common.regression.ResourceReader;
import com.hp.hpl.mesa.rdf.jena.model.Model;
import com.hp.hpl.mesa.rdf.jena.model.RDFException;
import com.hp.hpl.mesa.rdf.jena.model.StmtIterator;

public class testNTripleReader {
    private boolean inError = false;

    protected static void doTest(Model model) {
        new testNTripleReader().test(model);
    }

    void test(Model model) {
        String string = "testNTripleReader";
        String string2 = "modules/rdf/regression/" + string + "/";
        int n = 0;
        try {
            this.empty(model);
            ++n;
            model.read(new ResourceReader(string2 + "1.nt"), "", "N-TRIPLE");
            if (model.size() != 5L) {
                this.error(string, n);
            }
            StmtIterator stmtIterator = model.listStatements(new SelectorImpl(null, null, "foo\"\\\n\r\tbar"));
            ++n;
            if (!stmtIterator.hasNext()) {
                this.error(string, n);
            }
        }
        catch (Exception exception) {
            this.inError = true;
            ErrorHelper.logInternalError(" test " + string, n, exception);
        }
    }

    protected void empty(Model model) throws RDFException {
        StmtIterator stmtIterator = model.listStatements();
        while (stmtIterator.hasNext()) {
            stmtIterator.next();
            stmtIterator.remove();
        }
    }

    protected void error(String string, int n) {
        System.out.println(string + ": failed test " + Integer.toString(n));
        this.inError = true;
    }

    public boolean getErrors() {
        return this.inError;
    }
}

