/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.connectionpool;

import com.netflix.astyanax.connectionpool.Connection;
import com.netflix.astyanax.connectionpool.Host;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;

public interface HostConnectionPool<CL> {
    public Connection<CL> borrowConnection(int var1) throws ConnectionException;

    public boolean returnConnection(Connection<CL> var1);

    public boolean closeConnection(Connection<CL> var1);

    public void markAsDown(ConnectionException var1);

    public void shutdown();

    public int primeConnections(int var1) throws ConnectionException, InterruptedException;

    public Host getHost();

    public int getActiveConnectionCount();

    public int getPendingConnectionCount();

    public int getBlockedThreadCount();

    public int getIdleConnectionCount();

    public int getBusyConnectionCount();

    public boolean isReconnecting();

    public boolean isActive();

    public boolean isShutdown();

    public double getScore();

    public void addLatencySample(long var1, long var3);

    public int getOpenedConnectionCount();

    public int getFailedOpenConnectionCount();

    public int getClosedConnectionCount();

    public int getErrorsSinceLastSuccess();

    public int getConnectAttemptCount();
}

