/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.util.TraversingItemVisitor;
import org.apache.jackrabbit.api.security.principal.ItemBasedPrincipal;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.Group;
import org.apache.jackrabbit.api.security.user.User;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeImpl;
import org.apache.jackrabbit.core.security.principal.PrincipalImpl;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.core.security.user.UserManagerImpl;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AuthorizableImpl
implements Authorizable,
UserConstants {
    static final Logger log = LoggerFactory.getLogger(AuthorizableImpl.class);
    final UserManagerImpl userManager;
    private final NodeImpl node;
    private int hashCode;

    protected AuthorizableImpl(NodeImpl node, UserManagerImpl userManager) throws RepositoryException {
        this.node = node;
        this.userManager = userManager;
    }

    public String getID() throws RepositoryException {
        return Text.unescapeIllegalJcrChars((String)this.getNode().getName());
    }

    public Iterator<Group> declaredMemberOf() throws RepositoryException {
        HashSet<Group> memberShip = new HashSet<Group>();
        this.collectMembership(memberShip, false);
        return memberShip.iterator();
    }

    public Iterator<Group> memberOf() throws RepositoryException {
        HashSet<Group> memberShip = new HashSet<Group>();
        this.collectMembership(memberShip, true);
        return memberShip.iterator();
    }

    public Iterator<String> getPropertyNames() throws RepositoryException {
        ArrayList<String> l = new ArrayList<String>();
        PropertyIterator it = this.node.getProperties();
        while (it.hasNext()) {
            Property prop = it.nextProperty();
            if (!AuthorizableImpl.isAuthorizableProperty(prop)) continue;
            l.add(prop.getName());
        }
        return l.iterator();
    }

    public boolean hasProperty(String name) throws RepositoryException {
        return this.node.hasProperty(name) && AuthorizableImpl.isAuthorizableProperty(this.node.getProperty(name));
    }

    public Value[] getProperty(String name) throws RepositoryException {
        Property prop;
        if (this.hasProperty(name) && AuthorizableImpl.isAuthorizableProperty(prop = this.node.getProperty(name))) {
            if (prop.isMultiple()) {
                return prop.getValues();
            }
            return new Value[]{prop.getValue()};
        }
        return null;
    }

    public synchronized void setProperty(String name, Value value) throws RepositoryException {
        this.checkProtectedProperty(name);
        try {
            Property p;
            if (this.node.hasProperty(name) && (p = this.node.getProperty(name)).isMultiple()) {
                p.remove();
            }
            this.node.setProperty(name, value);
            if (this.userManager.isAutoSave()) {
                this.node.save();
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to set Property " + name + " for " + this, (Throwable)e);
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized void setProperty(String name, Value[] values) throws RepositoryException {
        this.checkProtectedProperty(name);
        try {
            Property p;
            if (this.node.hasProperty(name) && !(p = this.node.getProperty(name)).isMultiple()) {
                p.remove();
            }
            this.node.setProperty(name, values);
            if (this.userManager.isAutoSave()) {
                this.node.save();
            }
        }
        catch (RepositoryException e) {
            log.warn("Failed to set Property " + name + " for " + this, (Throwable)e);
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized boolean removeProperty(String name) throws RepositoryException {
        this.checkProtectedProperty(name);
        try {
            if (this.node.hasProperty(name)) {
                Property p = this.node.getProperty(name);
                if (p.isMultiple()) {
                    p.setValue((Value[])null);
                } else {
                    p.setValue((Value)null);
                }
                if (this.userManager.isAutoSave()) {
                    this.node.save();
                }
                return true;
            }
            return false;
        }
        catch (RepositoryException e) {
            log.warn("Failed to remove Property " + name + " from " + this, (Throwable)e);
            this.node.refresh(false);
            throw e;
        }
    }

    public synchronized void remove() throws RepositoryException {
        if (!this.isGroup() && ((User)this).isAdmin()) {
            throw new RepositoryException("The administrator cannot be removed.");
        }
        SessionImpl s = this.getSession();
        this.node.remove();
        if (this.userManager.isAutoSave()) {
            s.save();
        }
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            try {
                StringBuilder sb = new StringBuilder();
                sb.append(this.isGroup() ? "group:" : "user:");
                sb.append(this.getSession().getWorkspace().getName());
                sb.append(":");
                sb.append(this.node.getIdentifier());
                this.hashCode = sb.toString().hashCode();
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return this.hashCode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AuthorizableImpl) {
            AuthorizableImpl otherAuth = (AuthorizableImpl)obj;
            try {
                return this.isGroup() == otherAuth.isGroup() && this.node.isSame(otherAuth.node);
            }
            catch (RepositoryException repositoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        try {
            String typeStr = this.isGroup() ? "Group '" : "User '";
            return typeStr + this.getID() + "'";
        }
        catch (RepositoryException e) {
            return super.toString();
        }
    }

    NodeImpl getNode() {
        return this.node;
    }

    SessionImpl getSession() throws RepositoryException {
        return (SessionImpl)this.node.getSession();
    }

    String getPrincipalName() throws RepositoryException {
        return this.node.getProperty(P_PRINCIPAL_NAME).getString();
    }

    private void collectMembership(final Set<Group> groups, boolean includeIndirect) throws RepositoryException {
        PropertyIterator refs = this.getMembershipReferences();
        if (refs != null) {
            while (refs.hasNext()) {
                try {
                    NodeImpl n = (NodeImpl)refs.nextProperty().getParent();
                    if (n.isNodeType(NT_REP_GROUP)) {
                        Group group = this.userManager.createGroup(n);
                        if (!groups.add(group) || !includeIndirect) continue;
                        ((AuthorizableImpl)group).collectMembership(groups, true);
                        continue;
                    }
                    log.debug("Invalid member reference to '" + this + "' -> Not included in membership set.");
                }
                catch (ItemNotFoundException e) {
                }
                catch (AccessDeniedException e) {}
            }
        } else {
            log.info("Traversing groups tree to collect membership.");
            TraversingItemVisitor.Default visitor = new TraversingItemVisitor.Default(){

                protected void entering(Property property, int level) throws RepositoryException {
                    PropertyImpl pImpl = (PropertyImpl)property;
                    NodeImpl n = (NodeImpl)pImpl.getParent();
                    if (UserConstants.P_MEMBERS.equals(pImpl.getQName()) && n.isNodeType(UserConstants.NT_REP_GROUP)) {
                        for (Value value : property.getValues()) {
                            if (!value.getString().equals(AuthorizableImpl.this.node.getIdentifier())) continue;
                            Group gr = (Group)AuthorizableImpl.this.userManager.getAuthorizable(n);
                            groups.add(gr);
                        }
                    }
                }
            };
            Node groupsNode = this.getSession().getNode(this.userManager.getGroupsPath());
            visitor.visit(groupsNode);
        }
    }

    private PropertyIterator getMembershipReferences() {
        PropertyIterator refs = null;
        try {
            refs = this.node.getWeakReferences(this.getSession().getJCRName(P_MEMBERS));
        }
        catch (RepositoryException e) {
            log.error("Failed to retrieve membership references of " + this + ".", (Throwable)e);
        }
        return refs;
    }

    private static boolean isAuthorizableProperty(Property prop) throws RepositoryException {
        PropertyDefinition def = prop.getDefinition();
        if (def.isProtected()) {
            return false;
        }
        NodeTypeImpl declaringNt = (NodeTypeImpl)prop.getDefinition().getDeclaringNodeType();
        return declaringNt.isNodeType(UserConstants.NT_REP_AUTHORIZABLE);
    }

    private boolean isProtectedProperty(String propertyName) throws RepositoryException {
        Name pName = this.getSession().getQName(propertyName);
        return P_PRINCIPAL_NAME.equals(pName) || P_MEMBERS.equals(pName) || P_IMPERSONATORS.equals(pName) || P_PASSWORD.equals(pName);
    }

    private void checkProtectedProperty(String propertyName) throws ConstraintViolationException, RepositoryException {
        if (this.isProtectedProperty(propertyName)) {
            throw new ConstraintViolationException("Attempt to modify protected property " + propertyName + " of " + this);
        }
    }

    class NodeBasedPrincipal
    extends PrincipalImpl
    implements ItemBasedPrincipal {
        NodeBasedPrincipal(String name) {
            super(name);
        }

        public String getPath() throws RepositoryException {
            return AuthorizableImpl.this.node.getPath();
        }
    }
}

