/*
 * Decompiled with CFR 0.152.
 */
package com.metaparadigm.jsonrpc;

import java.io.CharArrayWriter;
import java.io.PrintWriter;
import org.json.JSONObject;

public class JSONRPCResult {
    private Object result = null;
    private Object id = null;
    private int errorCode;
    public static final int CODE_SUCCESS = 0;
    public static final int CODE_REMOTE_EXCEPTION = 490;
    public static final int CODE_ERR_PARSE = 590;
    public static final int CODE_ERR_NOMETHOD = 591;
    public static final int CODE_ERR_UNMARSHALL = 592;
    public static final int CODE_ERR_MARSHALL = 593;
    public static final String MSG_ERR_PARSE = "couldn't parse request arguments";
    public static final String MSG_ERR_NOMETHOD = "method not found (session may have timed out)";

    public JSONRPCResult(int errorCode, Object id, Object o) {
        this.errorCode = errorCode;
        this.id = id;
        this.result = o;
    }

    public Object getResult() {
        return this.result;
    }

    public Object getId() {
        return this.id;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String toString() {
        JSONObject o = new JSONObject();
        if (this.errorCode == 0) {
            o.put("id", this.id);
            o.put("result", this.result);
        } else if (this.errorCode == 490) {
            Throwable e = (Throwable)this.result;
            CharArrayWriter caw = new CharArrayWriter();
            e.printStackTrace(new PrintWriter(caw));
            JSONObject err = new JSONObject();
            err.put("code", (Object)new Integer(this.errorCode));
            err.put("msg", (Object)e.getMessage());
            err.put("trace", (Object)caw.toString());
            o.put("id", this.id);
            o.put("error", (Object)err);
        } else {
            JSONObject err = new JSONObject();
            err.put("code", (Object)new Integer(this.errorCode));
            err.put("msg", this.result);
            o.put("id", this.id);
            o.put("error", (Object)err);
        }
        return o.toString();
    }
}

