/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.tcp;

import gr.uoa.di.madgik.commons.server.ITCPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidArgumentException;
import gr.uoa.di.madgik.grs.proxy.GRS2ProxyInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.IProxy;
import gr.uoa.di.madgik.grs.proxy.tcp.TCPReaderProxy;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;

public class TCPStoreReaderProxy
extends TCPReaderProxy {
    private boolean storeContacted = false;

    @Override
    public void fromLocator(URI locator) throws GRS2ProxyInvalidArgumentException, GRS2ProxyInvalidOperationException {
        Socket socket = null;
        ObjectInputStream in = null;
        ObjectOutputStream out = null;
        try {
            if (this.storeContacted) {
                super.fromLocator(locator);
            } else {
                this.storeContacted = true;
                if (locator == null) {
                    throw new GRS2ProxyInvalidArgumentException("Locator cannot be null");
                }
                if (!TCPStoreReaderProxy.isOfType(locator)) {
                    throw new GRS2ProxyInvalidArgumentException("Locator is not of appropriate type " + locator.toString());
                }
                if (locator.getQuery() == null) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
                }
                String[] qs = locator.getQuery().trim().split("=");
                if (qs.length != 2) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid query string in locator " + locator.toString());
                }
                if (qs[1].trim().length() == 0) {
                    throw new GRS2ProxyInvalidArgumentException("Invalid key in locator " + locator.toString());
                }
                String hostname = locator.getHost();
                int port = locator.getPort();
                String key = qs[1];
                socket = new Socket(hostname, port);
                out = new ObjectOutputStream(new BufferedOutputStream(socket.getOutputStream()));
                out.writeUTF(ITCPConnectionManagerEntry.NamedEntry.gRS2Store.toString());
                out.writeUTF(key);
                out.flush();
                in = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
                URI newLocator = new URI(in.readUTF());
                this.fromLocator(newLocator);
            }
        }
        catch (UnknownHostException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidOperationException("Could not initialize new tcp locator", e);
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidOperationException("Could not initialize new tcp locator", e);
        }
        catch (URISyntaxException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new GRS2ProxyInvalidOperationException("Could not initialize new tcp locator", e);
        }
    }

    @Override
    public IBuffer getBuffer() throws GRS2ProxyInvalidOperationException {
        if (!this.storeContacted) {
            throw new GRS2ProxyInvalidOperationException("Method not supported for this proxy type");
        }
        return super.getBuffer();
    }

    public static boolean isOfType(URI locator) {
        if (!locator.getScheme().equalsIgnoreCase("grs2-store-proxy".toString())) {
            return false;
        }
        return locator.getFragment().equalsIgnoreCase(IProxy.ProxyType.TCPStore.toString());
    }
}

