/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.grs.proxy.http.mirror;

import gr.uoa.di.madgik.commons.server.http.IHTTPConnectionManagerEntry;
import gr.uoa.di.madgik.grs.GRS2Exception;
import gr.uoa.di.madgik.grs.buffer.GRS2BufferException;
import gr.uoa.di.madgik.grs.buffer.IBuffer;
import gr.uoa.di.madgik.grs.events.BufferEvent;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorDisposedException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorInvalidOperationException;
import gr.uoa.di.madgik.grs.proxy.mirror.GRS2ProxyMirrorProtocolErrorException;
import gr.uoa.di.madgik.grs.proxy.mirror.IMirror;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestEntry;
import gr.uoa.di.madgik.grs.proxy.mirror.PartialRequestManager;
import gr.uoa.di.madgik.grs.record.GRS2RecordDefinitionException;
import gr.uoa.di.madgik.grs.record.GRS2RecordSerializationException;
import gr.uoa.di.madgik.grs.record.Record;
import gr.uoa.di.madgik.grs.record.RecordDefinition;
import gr.uoa.di.madgik.grs.record.field.Field;
import gr.uoa.di.madgik.grs.xml.XMLHelper;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class HTTPReaderMirror
extends Thread
implements IMirror {
    private static Logger logger = Logger.getLogger(HTTPReaderMirror.class.getName());
    public static final long LongMirrorPeriod = 100L;
    public static final long ShortMirrorPeriod = 50L;
    public static final int ReaderTimout = 10000;
    private String hostname = null;
    private int port = -1;
    private String key = null;
    private boolean overrideBufferCapacity = false;
    private int bufferCapacity = -1;
    private IMirror.MirroringState state = IMirror.MirroringState.Open;
    private InputStream in;
    private OutputStream out;
    private IBuffer buffer = null;
    private GRS2ProxyMirrorProtocolErrorException initializationException = null;
    private final Object initializationLock = new Object();
    private boolean initializationCompleted = false;
    private long lastIterationRecords = 0L;
    private long lastPartialFields = 0L;
    private long lastIterationNeeded = 0L;
    private long lastAvailableRecords = 0L;
    private boolean consequentNoNeeds = false;
    private PartialRequestManager manager = new PartialRequestManager();
    private HttpURLConnection conn;

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void overrideBufferCapacity(int capacity) {
        this.overrideBufferCapacity = true;
        this.bufferCapacity = capacity;
    }

    @Override
    public IBuffer getBuffer() {
        return this.buffer;
    }

    public void handle() throws GRS2ProxyMirrorInvalidOperationException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Invalid mirroring state");
        }
        if (this.key == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No key defined");
        }
        if (this.hostname == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("No hostname defined");
        }
        if (this.port <= 0) {
            throw new GRS2ProxyMirrorInvalidOperationException("No port defined");
        }
        this.setDaemon(true);
        this.setName("reader mirror (" + this.key + ")");
        this.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean purge) {
        if (this.state == IMirror.MirroringState.Purged) {
            return;
        }
        this.state = purge ? IMirror.MirroringState.Purged : IMirror.MirroringState.Close;
        if (purge) {
            this.close();
            try {
                if (this.buffer != null) {
                    logger.log(Level.FINER, "Disposing buffer");
                    this.buffer.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.manager != null) {
                    this.manager.dispose();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.manager = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitInitialization() {
        Object object = this.initializationLock;
        synchronized (object) {
            while (!this.initializationCompleted) {
                try {
                    this.initializationLock.wait();
                }
                catch (Exception exception) {}
            }
            return this.initializationException == null;
            {
            }
        }
    }

    public GRS2ProxyMirrorProtocolErrorException getInitializationError() {
        return this.initializationException;
    }

    @Override
    public boolean pollPartial(long recordIndex, int fieldIndex) throws GRS2ProxyMirrorDisposedException {
        if (this.state != IMirror.MirroringState.Open) {
            return true;
        }
        if (this.manager == null) {
            return true;
        }
        return !this.manager.requestExists(recordIndex, fieldIndex);
    }

    @Override
    public long requestPartial(long recordIndex, int fieldIndex, IBuffer.TransportOverride override, Object notify) throws GRS2ProxyMirrorInvalidOperationException, GRS2ProxyMirrorDisposedException {
        if (this.state != IMirror.MirroringState.Open) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is closing. No additional request accepted");
        }
        if (this.manager == null) {
            throw new GRS2ProxyMirrorInvalidOperationException("Mirroring is closing. No additional request accepted");
        }
        this.manager.block(recordIndex, fieldIndex, override, notify);
        return 50L;
    }

    private void bufferInit() throws Exception {
        this.conn = this.connectToWriter(false);
        this.in = this.conn.getInputStream();
        this.initializeBuffer();
    }

    private boolean readerRequests() throws Exception {
        DocumentBuilder docBuilder;
        boolean teardown = true;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new GRS2Exception("Couldn't create an XML document", e);
        }
        Document doc = docBuilder.newDocument();
        Element element = doc.createElement("totalRequest");
        logger.log(Level.FINEST, "HTTPReaderMirror : flushRequest....");
        teardown = this.flushRequest(doc, element);
        logger.log(Level.FINEST, "HTTPReaderMirror : flushRequest....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : flushEvents....");
        this.flushEvents(doc, element);
        logger.log(Level.FINEST, "HTTPReaderMirror : flushEvents....OK");
        doc.appendChild(element);
        this.sendHTTP(doc);
        return teardown;
    }

    private Integer retrieve() throws Exception {
        this.in = this.conn.getInputStream();
        Document doc = null;
        doc = XMLHelper.getXMLDocument(this.in);
        logger.log(Level.FINEST, "HTTPReaderMirror : retrievePartialRequests....");
        this.retrievePartialRequests(doc);
        logger.log(Level.FINEST, "HTTPReaderMirror : retrievePartialRequests....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveRecords....");
        this.retrieveRecords(doc);
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveRecords....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveEvents....");
        this.retrieveEvents(doc);
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveEvents....OK");
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveStatus....");
        Integer isClosed = this.retrieveStatus(doc);
        logger.log(Level.FINEST, "HTTPReaderMirror : retrieveStatus....OK");
        return isClosed;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void retrievePartialRequests(Document doc) throws GRS2Exception {
        Element element = doc.getDocumentElement();
        NodeList partialRequests = element.getElementsByTagName("partialRecords").item(0).getChildNodes();
        for (int i = 0; i < partialRequests.getLength(); ++i) {
            Element partialRequest = (Element)partialRequests.item(i);
            long recordIndex = Long.valueOf(partialRequest.getElementsByTagName("partRecordIndex").item(0).getTextContent());
            int fieldIndex = Integer.valueOf(partialRequest.getElementsByTagName("fieldIndex").item(0).getTextContent());
            IBuffer.TransportOverride override = IBuffer.TransportOverride.valueOf(partialRequest.getElementsByTagName("override").item(0).getTextContent());
            Record rec = this.buffer.locate(recordIndex);
            if (rec == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid record index provided");
            }
            Field[] fields = rec.getFields();
            if (fields == null) {
                throw new GRS2ProxyMirrorInvalidOperationException("No fields to update");
            }
            if (fieldIndex < 0 || fieldIndex >= fields.length) {
                throw new GRS2ProxyMirrorInvalidOperationException("Invalid field index provided");
            }
            Field f = fields[fieldIndex];
            f.extendReceiveFromXML(doc.getDocumentElement(), override);
            this.manager.unblock(recordIndex, fieldIndex);
        }
    }

    private void retrieveRecords(Document doc) throws GRS2Exception, InstantiationException, IllegalAccessException, ClassNotFoundException {
        Element element = doc.getDocumentElement();
        NodeList records = (element = (Element)element.getElementsByTagName("records").item(0)).getChildNodes();
        if (records != null) {
            for (int i = 0; i < records.getLength(); ++i) {
                Element record = (Element)records.item(i);
                String recordClass = record.getElementsByTagName("recordClass").item(0).getTextContent();
                Record rec = (Record)Class.forName(recordClass).newInstance();
                rec.prebind(this.buffer);
                rec.receiveFromXML(record);
                rec.setRemoteCopy(true);
                this.buffer.put(rec);
                ++this.lastIterationRecords;
            }
        }
    }

    private void retrieveEvents(Document doc) throws GRS2RecordSerializationException, GRS2RecordDefinitionException, DOMException, InstantiationException, IllegalAccessException, ClassNotFoundException, GRS2BufferException {
        Element element = doc.getDocumentElement();
        NodeList events = element.getElementsByTagName("events").item(0).getChildNodes();
        if (events != null) {
            int len = events.getLength();
            for (int i = 0; i < len; ++i) {
                Element event = (Element)events.item(i);
                String eventType = event.getElementsByTagName("eventType").item(0).getTextContent();
                BufferEvent ev = (BufferEvent)Class.forName(eventType).newInstance();
                ev.fromXML(event);
                this.buffer.emit(ev);
            }
        }
    }

    private Integer retrieveStatus(Document doc) throws GRS2RecordSerializationException {
        Element element = doc.getDocumentElement();
        Integer isClosed = Integer.valueOf(element.getElementsByTagName("status").item(0).getTextContent());
        return isClosed;
    }

    private void flushEvents(Document doc, Element element) throws Exception {
        BufferEvent event;
        Element events = doc.createElement("events");
        while ((event = this.buffer.receive(BufferEvent.EventSource.Reader)) != null) {
            Element eventEl = doc.createElement("event");
            Element eventType = doc.createElement("eventType");
            eventType.setTextContent(event.getClass().getName());
            eventEl.appendChild(eventType);
            Element eventExt = event.toXML(doc);
            eventEl.appendChild(eventExt);
            events.appendChild(eventEl);
        }
        element.appendChild(events);
    }

    private boolean flushRequest(Document doc, Element element) throws Exception {
        boolean doDispose = false;
        int needed = 0;
        int availableRecords = -1;
        try {
            if (this.state != IMirror.MirroringState.Open || this.buffer.getStatus() == IBuffer.Status.Dispose) {
                doDispose = true;
            } else {
                availableRecords = this.buffer.availableRecords();
                needed = this.buffer.getCapacity() - availableRecords;
            }
        }
        catch (Exception ex) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Could not check for needed state flushing info. Setting to dispose", ex);
            }
            doDispose = true;
        }
        long consumed = this.lastAvailableRecords - (long)availableRecords;
        if (consumed < 0L) {
            consumed *= -1L;
        }
        this.lastAvailableRecords = availableRecords;
        if (this.lastAvailableRecords > 0L && needed > 0 && (int)consumed < needed) {
            needed = (int)consumed;
        }
        this.consequentNoNeeds = this.lastIterationNeeded == 0L && needed == 0;
        this.lastIterationNeeded = needed;
        Element requestEl = doc.createElement("request");
        Element el = doc.createElement("doDispose");
        el.setTextContent(String.valueOf(doDispose));
        requestEl.appendChild(el);
        el = doc.createElement("needed");
        el.setTextContent(String.valueOf(needed));
        requestEl.appendChild(el);
        boolean simulateActivity = this.buffer.getSimulateActivity();
        el = doc.createElement("simulateActivity");
        el.setTextContent(String.valueOf(simulateActivity));
        requestEl.appendChild(el);
        if (this.manager != null && !doDispose) {
            PartialRequestEntry[] entries = this.manager.getEntries();
            Element partialRequestEntries = doc.createElement("partialRequestEntries");
            this.lastPartialFields = entries.length;
            for (PartialRequestEntry entry : entries) {
                Element partialRequestEntry = doc.createElement("partialRequestEntry");
                Element elm = doc.createElement("recordIndex");
                elm.setTextContent(String.valueOf(entry.getRecordIndex()));
                partialRequestEntry.appendChild(elm);
                elm = doc.createElement("fieldIndex");
                elm.setTextContent(String.valueOf(entry.getFieldIndex()));
                partialRequestEntry.appendChild(elm);
                elm = doc.createElement("override");
                elm.setTextContent(String.valueOf(entry.getOverride().toString()));
                partialRequestEntry.appendChild(elm);
                partialRequestEntries.appendChild(partialRequestEntry);
            }
            requestEl.appendChild(partialRequestEntries);
        }
        element.appendChild(requestEl);
        logger.log(Level.FINEST, "Flush request doDispose=" + doDispose + " mirroring state=" + (Object)((Object)this.state));
        return doDispose;
    }

    private HttpURLConnection connectToWriter(boolean output) throws Exception {
        this.init();
        String url = "http://" + this.hostname + ":" + this.port;
        logger.log(Level.FINEST, "HTTPReaderMirror : Reader created connection....");
        logger.log(Level.FINEST, "HTTPReaderMirror : url : " + url);
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        output = true;
        connection.setDoOutput(output);
        connection.setRequestMethod("POST");
        connection.setRequestProperty("key", this.key);
        connection.setRequestProperty("EntryName", IHTTPConnectionManagerEntry.NamedEntry.gRS2.name());
        if (output) {
            this.out = connection.getOutputStream();
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(this.out));
            out.flush();
        }
        return connection;
    }

    private void initializeBuffer() throws Exception {
        Document doc = null;
        doc = XMLHelper.getXMLDocument(this.in);
        logger.log(Level.FINEST, "In initializeBuffer XML document parsed");
        Element element = doc.getDocumentElement();
        String bufferType = element.getElementsByTagName("bufferClass").item(0).getTextContent();
        int capacity = Integer.parseInt(element.getElementsByTagName("capacity").item(0).getTextContent());
        int concurrentPartial = Integer.parseInt(element.getElementsByTagName("concurrentPartialCapacity").item(0).getTextContent());
        long inactivityTimeout = Long.parseLong(element.getElementsByTagName("inactivityTimeout").item(0).getTextContent());
        TimeUnit InactivityTimeUnit = TimeUnit.valueOf(element.getElementsByTagName("inactivityTimeUnit").item(0).getTextContent());
        IBuffer.TransportDirective transportDirective = IBuffer.TransportDirective.valueOf(element.getElementsByTagName("transportDirective").item(0).getTextContent());
        NodeList recordDefinitions = element.getElementsByTagName("recordDefinitions").item(0).getChildNodes();
        RecordDefinition[] definitions = null;
        if (recordDefinitions != null && recordDefinitions.getLength() > 0) {
            int len = recordDefinitions.getLength();
            definitions = new RecordDefinition[len];
            for (int i = 0; i < len; ++i) {
                Element recordDefinition = (Element)recordDefinitions.item(i);
                String recordDefType = recordDefinition.getElementsByTagName("recordDefinitionClass").item(0).getTextContent();
                RecordDefinition def = (RecordDefinition)Class.forName(recordDefType).newInstance();
                def.fromXML(recordDefinition);
                definitions[i] = def;
            }
        }
        this.buffer = (IBuffer)Class.forName(bufferType).newInstance();
        if (this.overrideBufferCapacity && this.bufferCapacity < capacity) {
            this.buffer.setCapacity(this.bufferCapacity);
        } else {
            this.buffer.setCapacity(capacity);
        }
        this.buffer.setConcurrentPartialCapacity(concurrentPartial);
        this.buffer.setInactivityTimeout(inactivityTimeout);
        this.buffer.setInactivityTimeUnit(InactivityTimeUnit);
        this.buffer.setTransportDirective(transportDirective);
        this.buffer.setRecordDefinitions(definitions);
        this.buffer.initialize();
    }

    private void sendHTTP(Document doc) throws Exception {
        this.conn = this.connectToWriter(true);
        XMLHelper.sendXML(doc, this.out);
    }

    private void init() {
        this.out = null;
        this.in = null;
        this.conn = null;
    }

    private void close() {
        try {
            if (this.out != null) {
                this.out.flush();
                this.out.close();
            }
            if (this.in != null) {
                this.in.close();
            }
            if (this.conn != null) {
                this.conn.disconnect();
            }
            logger.log(Level.FINEST, "HTTPReaderMirror : Reader closed connection....");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            this.init();
        }
    }
}

