/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.CompositeDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.mime.MimeTypes;

public class DefaultDetector
extends CompositeDetector {
    private static final long serialVersionUID = -8170114575326908027L;
    private final transient ServiceLoader loader;

    private static List<Detector> getDefaultDetectors(MimeTypes types, ServiceLoader loader) {
        List<Detector> detectors = loader.loadStaticServiceProviders(Detector.class);
        Collections.sort(detectors, new Comparator<Detector>(){

            @Override
            public int compare(Detector d1, Detector d2) {
                boolean t2;
                String n1 = d1.getClass().getName();
                String n2 = d2.getClass().getName();
                boolean t1 = n1.startsWith("org.apache.tika.");
                if (t1 == (t2 = n2.startsWith("org.apache.tika."))) {
                    return n1.compareTo(n2);
                }
                if (t1) {
                    return 1;
                }
                return -1;
            }
        });
        detectors.add(types);
        return detectors;
    }

    public DefaultDetector(MimeTypes types, ServiceLoader loader) {
        super(types.getMediaTypeRegistry(), DefaultDetector.getDefaultDetectors(types, loader));
        this.loader = loader;
    }

    public DefaultDetector(MimeTypes types, ClassLoader loader) {
        this(types, new ServiceLoader(loader));
    }

    public DefaultDetector(ClassLoader loader) {
        this(MimeTypes.getDefaultMimeTypes(), loader);
    }

    public DefaultDetector(MimeTypes types) {
        this(types, new ServiceLoader());
    }

    public DefaultDetector() {
        this(MimeTypes.getDefaultMimeTypes());
    }

    @Override
    public List<Detector> getDetectors() {
        if (this.loader != null) {
            List<Detector> detectors = this.loader.loadDynamicServiceProviders(Detector.class);
            detectors.addAll(super.getDetectors());
            return detectors;
        }
        return super.getDetectors();
    }
}

