/*
 * Decompiled with CFR 0.152.
 */
package org.walluck.oscar.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import org.walluck.oscar.AIMSession;
import org.walluck.oscar.AIMUtil;
import org.walluck.oscar.client.Buddy;
import org.walluck.oscar.client.Oscar;
import org.walluck.oscar.components.IMWindowListener;
import org.walluck.oscar.components.Main;
import org.walluck.oscar.components.SessionManager;

final class IMWindow
extends JFrame
implements ActionListener,
WindowListener {
    private Buddy buddy;
    private static HashMap imWindows = new HashMap();
    private JEditorPane incoming = new JEditorPane();
    private JTextArea outgoing = new JTextArea(3, 30);
    private JScrollPane scroll = new JScrollPane(this.incoming);
    private JMenu sendAs;

    private IMWindow(Buddy buddy) {
        this.buddy = buddy;
        this.setTitle(this.buddy.getName() + " - Instant Message");
        this.buildUI();
        this.pack();
        this.addWindowListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equals("send_im")) {
            AIMSession session = null;
            if (this.sendAs != null) {
                for (int i = this.sendAs.getItemCount() - 1; i >= 0; --i) {
                    JMenuItem menu = this.sendAs.getItem(i);
                    if (!((JRadioButtonMenuItem)menu).isSelected()) continue;
                    session = (AIMSession)menu.getClientProperty("aim_session");
                    break;
                }
            } else {
                session = SessionManager.getSessions()[0];
            }
            final AIMSession sess = session;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    String msg = AIMUtil.convertHTMLToOSCAR(IMWindow.this.outgoing.getText());
                    if (msg.length() != 0) {
                        Exception e = IMWindow.sendIM(sess, IMWindow.this.buddy.getName(), msg);
                        if (e != null) {
                            e.printStackTrace();
                        } else {
                            IMWindow.this.appendIM(sess, sess.getSN(), msg, false);
                            JScrollBar bar = IMWindow.this.scroll.getVerticalScrollBar();
                            bar.setValue(bar.getMaximum() + bar.getVisibleAmount());
                        }
                        IMWindow.this.outgoing.setText("");
                    }
                }
            });
        }
    }

    public void appendIM(AIMSession sess, String from, String message, boolean isAutoResponse) {
        String sn = from;
        message = AIMUtil.convertOSCARToHTML(message);
        if (isAutoResponse) {
            from = from + " &lt;AUTO-REPLY&gt;";
        }
        from = sn.equals(sess.getSN()) ? "<B><FONT COLOR=\"blue\">" + from + ": " + "</FONT></B>" : "<B><FONT COLOR=\"red\">" + from + ": " + "</FONT></B>";
        String str = "(" + new SimpleDateFormat("HH:mm:ss").format(new Date()) + ") " + from + message + "<br>";
        boolean scrollEnd = false;
        if (this.scroll.getVerticalScrollBar() != null) {
            scrollEnd = this.scroll.getVerticalScrollBar().getValue() + this.scroll.getVerticalScrollBar().getVisibleAmount() == this.scroll.getVerticalScrollBar().getMaximum();
        }
        try {
            HTMLDocument doc = (HTMLDocument)this.incoming.getDocument();
            doc.insertBeforeEnd(this.findElement(doc, "p"), str);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (scrollEnd) {
            this.scroll.getVerticalScrollBar().setValue(this.scroll.getVerticalScrollBar().getMaximum());
        }
    }

    private Element findElement(Element elm, String name) {
        for (int i = 0; i < elm.getElementCount(); ++i) {
            Element e = elm.getElement(i);
            if (name.equals(e.getName())) {
                return e;
            }
            if ((e = this.findElement(e, name)) == null) continue;
            return e;
        }
        return null;
    }

    private Element findElement(Document doc, String name) {
        return this.findElement(doc.getDefaultRootElement(), name);
    }

    private void buildMenu() {
        JMenuBar mbar = new JMenuBar();
        this.setJMenuBar(mbar);
        this.buildSendAsMenu();
    }

    private void buildSendAsMenu() {
        AIMSession[] session = SessionManager.getSessions();
        if (session.length != 1) {
            this.sendAs = new JMenu("Send As");
            ButtonGroup g = new ButtonGroup();
            this.getJMenuBar().add(this.sendAs);
            for (int i = 0; i < session.length; ++i) {
                JRadioButtonMenuItem item = new JRadioButtonMenuItem(session[i].getSN());
                item.putClientProperty("aim_session", session[i]);
                this.sendAs.add(item);
                g.add(item);
                if (i != 0) continue;
                item.setSelected(true);
            }
        }
    }

    private void buildUI() {
        this.incoming.setEditable(false);
        this.incoming.setContentType("text/html");
        this.incoming.setDocument(this.incoming.getEditorKit().createDefaultDocument());
        this.incoming.setPreferredSize(new Dimension(300, 200));
        JPanel panel = new JPanel(new BorderLayout());
        this.outgoing.setWrapStyleWord(true);
        this.outgoing.setLineWrap(true);
        this.outgoing.setPreferredSize(new Dimension(300, 200));
        panel.add((Component)new JScrollPane(this.outgoing), "Center");
        JSplitPane split = new JSplitPane(0, true, this.scroll, panel);
        JButton b = new JButton("Send");
        b.setActionCommand("send_im");
        panel.add((Component)b, "East");
        this.getContentPane().add((Component)split, "Center");
        b.addActionListener(this);
        this.buildMenu();
    }

    public static IMWindow createIMWindow(AIMSession sess, Buddy buddy) {
        String sn = AIMUtil.normalize(buddy.getName());
        IMWindow w = (IMWindow)imWindows.get(sn);
        if (w == null) {
            w = new IMWindow(buddy);
            imWindows.put(sn, w);
        } else {
            w.toFront();
        }
        Iterator i = sess.getListeners(253, 1);
        while (i.hasNext()) {
            ((IMWindowListener)((Object)i)).newConvo(sess, sn);
        }
        return w;
    }

    public static Exception sendIM(AIMSession session, String sn, String msg) {
        if (msg.length() == 0) {
            return new IllegalArgumentException("Cannot send a message of 0 length");
        }
        int flag = session.isICQ() ? Oscar.getICQCaps() : Main.OSCAR.getAIMCaps();
        try {
            Buddy b = Main.OSCAR.findBuddy(sn);
            Main.OSCAR.sendIM(session, sn, msg, flag);
        }
        catch (IOException e) {
            return e;
        }
        return null;
    }

    public void windowActivated(WindowEvent evt) {
    }

    public void windowClosed(WindowEvent evt) {
    }

    public void windowClosing(WindowEvent evt) {
        imWindows.remove(AIMUtil.normalize(this.buddy.getName()));
    }

    public void windowDeactivated(WindowEvent evt) {
    }

    public void windowDeiconified(WindowEvent evt) {
    }

    public void windowIconified(WindowEvent evt) {
    }

    public void windowOpened(WindowEvent evt) {
    }
}

