/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.jcr.workspace.accounting;

import com.thoughtworks.xstream.XStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Map;
import org.gcube.common.homelibary.model.items.accounting.AccountingDelegate;
import org.gcube.common.homelibary.model.items.accounting.AccountingEntryType;
import org.gcube.common.homelibary.model.items.accounting.AccountingProperty;
import org.gcube.common.homelibrary.home.workspace.accounting.AccountingEntryRead;
import org.gcube.common.homelibrary.jcr.workspace.accounting.JCRAccountingEntry;
import org.gcube.common.homelibrary.model.exceptions.RepositoryException;

public class JCRAccountingEntryRead
extends JCRAccountingEntry
implements AccountingEntryRead {
    private final String itemName;
    Map<AccountingProperty, String> properties;

    public JCRAccountingEntryRead(String id, String user, Calendar date, String itemName) {
        super(id, user, date);
        this.itemName = itemName;
        if (this.properties == null) {
            this.properties = this.entryDelegate.getAccountingProperties();
        }
        this.properties.put(AccountingProperty.ITEM_NAME, new XStream().toXML((Object)itemName));
        this.entryDelegate.setEntryType(AccountingEntryType.READ);
    }

    public JCRAccountingEntryRead(String id, String user, Calendar date, String itemName, String version) {
        this(id, user, date, itemName);
        this.version = version;
        if (version != null) {
            try {
                this.entryDelegate.setVersion(version);
            }
            catch (Exception e) {
                logger.error("Please update HL model");
            }
        }
    }

    public JCRAccountingEntryRead(AccountingDelegate node) throws RepositoryException {
        super(node);
        this.itemName = (String)new XStream().fromXML((String)this.entryDelegate.getAccountingProperties().get(AccountingProperty.ITEM_NAME));
        if (this.entryDelegate.getAccountingProperties().get(AccountingProperty.VERSION) != null) {
            try {
                this.version = (String)new XStream().fromXML((String)this.entryDelegate.getAccountingProperties().get(AccountingProperty.VERSION));
            }
            catch (Exception e) {
                this.version = "";
                logger.error("Please update HL model");
            }
        }
    }

    public String getItemName() {
        return this.itemName;
    }

    @Override
    public AccountingEntryType getEntryType() {
        return AccountingEntryType.READ;
    }

    @Override
    public String toString() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String user = super.getUser();
        Calendar date = super.getDate();
        String version = super.getVersion();
        return String.format("[ user:%s, date:%s, itemName:%s, version:%s [%s] ]", user, sdf.format(date.getTime()), this.itemName, version, this.getEntryType());
    }

    @Override
    public String getVersion() {
        return this.version;
    }
}

