/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedMethodInvoker;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sessions.Record;
import org.eclipse.persistence.sessions.Session;

public class MethodBaseQueryRedirector
implements QueryRedirector {
    protected Class methodClass;
    protected String methodClassName;
    protected String methodName;
    protected transient Method method;

    public MethodBaseQueryRedirector() {
    }

    public MethodBaseQueryRedirector(Class methodClass, String methodName) {
        this.methodClass = methodClass;
        this.methodName = methodName;
    }

    protected Method getMethod() {
        return this.method;
    }

    public Class getMethodClass() {
        return this.methodClass;
    }

    public String getMethodClassName() {
        if (this.methodClassName == null && this.methodClass != null) {
            this.methodClassName = this.methodClass.getName();
        }
        return this.methodClassName;
    }

    public String getMethodName() {
        return this.methodName;
    }

    protected void initializeMethod(DatabaseQuery query) throws QueryException {
        if (this.getMethodName() == null || this.getMethodClass() == null) {
            throw QueryException.redirectionClassOrMethodNotSet(query);
        }
        Class[] arguments = new Class[]{ClassConstants.SessionsSession_Class, ClassConstants.Vector_class};
        try {
            this.setMethod(Helper.getDeclaredMethod(this.getMethodClass(), this.getMethodName(), arguments));
        }
        catch (Exception ignore) {
            arguments = new Class[]{ClassConstants.DatabaseQuery_Class, ClassConstants.Record_Class, ClassConstants.SessionsSession_Class};
            try {
                this.setMethod(Helper.getDeclaredMethod(this.getMethodClass(), this.getMethodName(), arguments));
            }
            catch (Exception ignoreAgain) {
                arguments = new Class[]{ClassConstants.DatabaseQuery_Class, ClassConstants.Record_Class, ClassConstants.SessionsSession_Class};
                try {
                    this.setMethod(Helper.getDeclaredMethod(this.getMethodClass(), this.getMethodName(), arguments));
                }
                catch (Exception exception) {
                    throw QueryException.redirectionMethodNotDefinedCorrectly(this.getMethodClass(), this.getMethodName(), exception, query);
                }
            }
        }
        if (!Modifier.isStatic(this.getMethod().getModifiers())) {
            throw QueryException.redirectionMethodNotDefinedCorrectly(this.getMethodClass(), this.getMethodName(), null, query);
        }
    }

    public Object invokeQuery(DatabaseQuery query, Record arguments, Session session) {
        if (this.getMethod() == null) {
            this.initializeMethod(query);
        }
        Object result = null;
        if (this.getMethod().getParameterTypes().length == 3) {
            Object[] argumentArray = new Object[]{query, arguments, session};
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    result = AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod(), null, argumentArray));
                }
                result = PrivilegedAccessHelper.invokeMethod(this.getMethod(), null, argumentArray);
            }
            catch (Exception exception) {
                throw QueryException.redirectionMethodError(exception, query);
            }
        } else {
            Object[] argumentArray = new Object[]{session, ((AbstractRecord)arguments).getValues()};
            try {
                result = PrivilegedAccessHelper.shouldUsePrivilegedAccess() ? AccessController.doPrivileged(new PrivilegedMethodInvoker(this.getMethod(), null, argumentArray)) : PrivilegedAccessHelper.invokeMethod(this.getMethod(), null, argumentArray);
            }
            catch (Exception exception) {
                throw QueryException.redirectionMethodError(exception, query);
            }
        }
        return result;
    }

    protected void setMethod(Method newMethod) {
        this.method = newMethod;
    }

    public void setMethodClass(Class newMethodClass) {
        this.methodClass = newMethodClass;
    }

    public void setMethodClassName(String newMethodClassName) {
        this.methodClassName = newMethodClassName;
    }

    public void setMethodName(String newMethodName) {
        this.methodName = newMethodName;
    }
}

