/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.io.delta;

import com.liferay.io.delta.ByteChannelReader;
import com.liferay.io.delta.ByteChannelWriter;
import com.liferay.io.delta.Differ;
import com.liferay.io.delta.Patcher;
import com.liferay.io.delta.RollingChecksum;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;

public class DeltaUtil {
    public static final int BUFFER_FACTOR = 16;
    public static final byte DATA_KEY = 1;
    public static final byte EOF_KEY = 0;
    public static final byte PROTOCOL_VERSION = 1;
    public static final byte REFERENCE_KEY = 2;
    public static final byte REFERENCE_RANGE_KEY = 3;

    public static void checksums(FileChannel originalFileChannel, ByteChannelWriter checksumsByteChannelWriter) throws IOException {
        DeltaUtil.checksums(originalFileChannel, checksumsByteChannelWriter, 512);
    }

    public static void checksums(FileChannel originalFileChannel, ByteChannelWriter checksumsByteChannelWriter, int blockLength) throws IOException {
        RollingChecksum rollingChecksum = new RollingChecksum(originalFileChannel, blockLength);
        checksumsByteChannelWriter.resizeBuffer(320);
        ByteBuffer byteBuffer = checksumsByteChannelWriter.getBuffer();
        int blocksCount = (int)Math.ceil((double)originalFileChannel.size() / (double)blockLength);
        checksumsByteChannelWriter.ensureSpace(9);
        byteBuffer.put((byte)1);
        byteBuffer.putInt(blockLength);
        byteBuffer.putInt(blocksCount);
        while (rollingChecksum.hasNext()) {
            checksumsByteChannelWriter.ensureSpace(20);
            byteBuffer.putInt(rollingChecksum.weakChecksum());
            byteBuffer.put(rollingChecksum.strongChecksum());
            rollingChecksum.nextBlock();
        }
    }

    public static void delta(ReadableByteChannel modifiedReadableByteChannel, ByteChannelReader checksumsByteChannelReader, ByteChannelWriter deltaByteChannelWriter) throws IOException {
        Differ differ = new Differ();
        differ.delta(modifiedReadableByteChannel, checksumsByteChannelReader, deltaByteChannelWriter);
    }

    public static void patch(FileChannel originalFileChannel, WritableByteChannel patchedWritableByteChannel, ByteChannelReader deltaByteChannelReader) throws IOException {
        Patcher patcher = new Patcher();
        patcher.patch(originalFileChannel, patchedWritableByteChannel, deltaByteChannelReader);
    }
}

