/*
 * Decompiled with CFR 0.152.
 */
package jodd.servlet;

import java.util.Map;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import jodd.util.ref.ReferenceMap;
import jodd.util.ref.ReferenceType;

public class SessionMappingListener
implements HttpSessionListener {
    private static final Map<String, HttpSession> sessionMap = new ReferenceMap<String, HttpSession>(ReferenceType.STRONG, ReferenceType.WEAK);

    public static HttpSession getSession(String sid) {
        return sessionMap.get(sid);
    }

    public static void setSession(HttpSession session) {
        sessionMap.put(session.getId(), session);
    }

    public static HttpSession removeSession(String sid) {
        return sessionMap.remove(sid);
    }

    public void sessionCreated(HttpSessionEvent event) {
        SessionMappingListener.setSession(event.getSession());
    }

    public void sessionDestroyed(HttpSessionEvent event) {
        SessionMappingListener.removeSession(event.getSession().getId());
    }
}

