/*
 * Decompiled with CFR 0.152.
 */
package jodd.json.impl;

import java.util.Map;
import jodd.json.JsonContext;
import jodd.json.Path;
import jodd.json.impl.ValueJsonSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapJsonSerializer
extends ValueJsonSerializer<Map<?, ?>> {
    @Override
    public void serializeValue(JsonContext jsonContext, Map<?, ?> map) {
        jsonContext.writeOpenObject();
        int count = 0;
        Path currentPath = jsonContext.getPath();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            if (key != null) {
                currentPath.push(key.toString());
            } else {
                currentPath.push("null");
            }
            boolean include = true;
            if (value != null) {
                include = jsonContext.matchIgnoredPropertyTypes(value.getClass(), false, include);
                include = jsonContext.matchPathToQueries(include);
            }
            if (!include) {
                currentPath.pop();
                continue;
            }
            if (key == null) {
                jsonContext.pushName(null, count > 0);
            } else {
                jsonContext.pushName(key.toString(), count > 0);
            }
            jsonContext.serialize(value);
            if (jsonContext.isNamePopped()) {
                ++count;
            }
            currentPath.pop();
        }
        jsonContext.writeCloseObject();
    }
}

