/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.common.homelibrary.util.config.easyconf;

import java.net.URL;
import org.apache.commons.configuration.ConfigurationUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ClasspathUtil {
    private static final Log log = LogFactory.getLog(ClasspathUtil.class);

    public static Class locateClass(String name) throws ClassNotFoundException {
        Class<?> foundClass = null;
        if (foundClass == null) {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            try {
                foundClass = loader.loadClass(name);
                log.debug((Object)("Class loaded from the context classpath (" + name + ")"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (foundClass == null) {
            try {
                foundClass = ClassLoader.getSystemClassLoader().loadClass(name);
                log.debug((Object)("Class loaded from the system classpath (" + name + ")"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (foundClass == null) {
            throw new ClassNotFoundException("Class " + name + " was not found in context classpath nor system classpath");
        }
        return foundClass;
    }

    public static Class[] locateClasses(String[] classNames) throws ClassNotFoundException {
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classes.length; ++i) {
            classes[i] = ClasspathUtil.locateClass(classNames[i]);
        }
        return classes;
    }

    public static URL locateResource(String base, String name) {
        return ConfigurationUtils.locate((String)base, (String)name);
    }

    public static URL locateResource(String name) {
        return ConfigurationUtils.locate(null, (String)name);
    }
}

