/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.state;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.spi.state.NodeState;

public final class NodeStateUtils {
    private NodeStateUtils() {
    }

    public static boolean isHidden(@Nonnull String name) {
        return !name.isEmpty() && name.charAt(0) == ':';
    }

    @CheckForNull
    public static String getPrimaryTypeName(NodeState nodeState) {
        PropertyState ps = nodeState.getProperty("jcr:primaryType");
        return ps == null ? null : ps.getValue(Type.NAME);
    }

    @Nonnull
    public static NodeState getNode(@Nonnull NodeState node, @Nonnull String path) {
        for (String name : PathUtils.elements((String)((String)Preconditions.checkNotNull((Object)path)))) {
            node = node.getChildNode((String)Preconditions.checkNotNull((Object)name));
        }
        return node;
    }
}

