/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.spi.security;

import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.commit.CommitHook;
import org.apache.jackrabbit.oak.spi.commit.MoveTracker;
import org.apache.jackrabbit.oak.spi.commit.ValidatorProvider;
import org.apache.jackrabbit.oak.spi.lifecycle.RepositoryInitializer;
import org.apache.jackrabbit.oak.spi.lifecycle.WorkspaceInitializer;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.Context;
import org.apache.jackrabbit.oak.spi.xml.ProtectedItemImporter;

public interface SecurityConfiguration {
    @Nonnull
    public String getName();

    @Nonnull
    public ConfigurationParameters getParameters();

    @Nonnull
    public WorkspaceInitializer getWorkspaceInitializer();

    @Nonnull
    public RepositoryInitializer getRepositoryInitializer();

    @Nonnull
    public List<? extends CommitHook> getCommitHooks(@Nonnull String var1);

    @Nonnull
    public List<? extends ValidatorProvider> getValidators(@Nonnull String var1, @Nonnull Set<Principal> var2, @Nonnull MoveTracker var3);

    @Nonnull
    public List<ProtectedItemImporter> getProtectedItemImporters();

    @Nonnull
    public Context getContext();

    public static class Default
    implements SecurityConfiguration {
        @Override
        @Nonnull
        public String getName() {
            return "org.apache.jackrabbit.oak";
        }

        @Override
        @Nonnull
        public ConfigurationParameters getParameters() {
            return ConfigurationParameters.EMPTY;
        }

        @Override
        @Nonnull
        public WorkspaceInitializer getWorkspaceInitializer() {
            return WorkspaceInitializer.DEFAULT;
        }

        @Override
        @Nonnull
        public RepositoryInitializer getRepositoryInitializer() {
            return RepositoryInitializer.DEFAULT;
        }

        @Override
        @Nonnull
        public List<? extends CommitHook> getCommitHooks(String workspaceName) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<? extends ValidatorProvider> getValidators(String workspaceName, Set<Principal> principals, MoveTracker moveTracker) {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<ProtectedItemImporter> getProtectedItemImporters() {
            return Collections.emptyList();
        }

        @Override
        public Context getContext() {
            return new Context.Default();
        }
    }
}

