/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.user.query;

import com.google.common.base.Function;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.api.security.user.Authorizable;
import org.apache.jackrabbit.api.security.user.UserManager;
import org.apache.jackrabbit.oak.api.ResultRow;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.api.Tree;
import org.apache.jackrabbit.oak.spi.security.user.AuthorizableType;
import org.apache.jackrabbit.oak.spi.security.user.util.UserUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ResultRowToAuthorizable
implements Function<ResultRow, Authorizable> {
    private static final Logger log = LoggerFactory.getLogger(ResultRowToAuthorizable.class);
    private final UserManager userManager;
    private final Root root;
    private final AuthorizableType targetType;

    ResultRowToAuthorizable(@Nonnull UserManager userManager, @Nonnull Root root, @Nullable AuthorizableType targetType) {
        this.userManager = userManager;
        this.root = root;
        this.targetType = targetType == null || AuthorizableType.AUTHORIZABLE == targetType ? null : targetType;
    }

    public Authorizable apply(ResultRow row) {
        if (row != null) {
            return this.getAuthorizable(row.getPath());
        }
        return null;
    }

    @CheckForNull
    private Authorizable getAuthorizable(String resultPath) {
        Authorizable authorizable = null;
        try {
            String id;
            Tree tree = this.root.getTree(resultPath);
            AuthorizableType type = UserUtil.getType(tree);
            while (tree.exists() && !tree.isRoot() && type == null) {
                tree = tree.getParent();
                type = UserUtil.getType(tree);
            }
            if (tree.exists() && (this.targetType == null || this.targetType == type) && (id = UserUtil.getAuthorizableId(tree)) != null) {
                authorizable = this.userManager.getAuthorizable(id);
            }
        }
        catch (RepositoryException e) {
            log.debug("Failed to access authorizable " + resultPath);
        }
        return authorizable;
    }
}

