/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.security.authentication.token;

import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.felix.scr.annotations.Activate;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Service;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.security.authentication.token.TokenProviderImpl;
import org.apache.jackrabbit.oak.spi.security.ConfigurationBase;
import org.apache.jackrabbit.oak.spi.security.ConfigurationParameters;
import org.apache.jackrabbit.oak.spi.security.SecurityConfiguration;
import org.apache.jackrabbit.oak.spi.security.SecurityProvider;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenConfiguration;
import org.apache.jackrabbit.oak.spi.security.authentication.token.TokenProvider;
import org.apache.jackrabbit.oak.spi.security.user.UserConfiguration;

@Component
@Service(value={TokenConfiguration.class, SecurityConfiguration.class})
public class TokenConfigurationImpl
extends ConfigurationBase
implements TokenConfiguration {
    public TokenConfigurationImpl() {
    }

    public TokenConfigurationImpl(SecurityProvider securityProvider) {
        super(securityProvider, securityProvider.getParameters("org.apache.jackrabbit.oak.authentication.token"));
    }

    @Activate
    private void activate(Map<String, Object> properties) {
        this.setParameters(ConfigurationParameters.of(properties));
    }

    @Override
    @Nonnull
    public String getName() {
        return "org.apache.jackrabbit.oak.authentication.token";
    }

    @Override
    @Nonnull
    public TokenProvider getTokenProvider(Root root) {
        UserConfiguration uc = this.getSecurityProvider().getConfiguration(UserConfiguration.class);
        return new TokenProviderImpl(root, this.getParameters(), uc);
    }
}

