/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment.file;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.CRC32;

abstract class FileAccess {
    FileAccess() {
    }

    abstract boolean isMemoryMapped();

    abstract int length() throws IOException;

    abstract long crc32(int var1, int var2) throws IOException;

    abstract ByteBuffer read(int var1, int var2) throws IOException;

    abstract void close() throws IOException;

    static class Random
    extends FileAccess {
        private final RandomAccessFile file;

        Random(RandomAccessFile file) {
            this.file = file;
        }

        @Override
        boolean isMemoryMapped() {
            return false;
        }

        @Override
        public int length() throws IOException {
            long length = this.file.length();
            Preconditions.checkState((length < Integer.MAX_VALUE ? 1 : 0) != 0);
            return (int)length;
        }

        @Override
        public long crc32(int position, int length) throws IOException {
            CRC32 checksum = new CRC32();
            checksum.update(this.read(position, length).array());
            return checksum.getValue();
        }

        @Override
        public synchronized ByteBuffer read(int position, int length) throws IOException {
            ByteBuffer entry = ByteBuffer.allocate(length);
            this.file.seek(position);
            this.file.readFully(entry.array());
            return entry;
        }

        @Override
        public synchronized void close() throws IOException {
            this.file.close();
        }
    }

    static class Mapped
    extends FileAccess {
        private final MappedByteBuffer buffer;

        Mapped(RandomAccessFile file) throws IOException {
            this.buffer = file.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, file.length());
        }

        @Override
        boolean isMemoryMapped() {
            return true;
        }

        @Override
        public int length() {
            return this.buffer.remaining();
        }

        @Override
        public long crc32(int position, int length) {
            ByteBuffer entry = this.buffer.asReadOnlyBuffer();
            entry.position(entry.position() + position);
            byte[] data = new byte[length];
            entry.get(data);
            CRC32 checksum = new CRC32();
            checksum.update(data);
            return checksum.getValue();
        }

        @Override
        public ByteBuffer read(int position, int length) {
            ByteBuffer entry = this.buffer.asReadOnlyBuffer();
            entry.position(entry.position() + position);
            entry.limit(entry.position() + length);
            return entry.slice();
        }

        @Override
        public void close() {
        }
    }
}

