/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.segment;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jackrabbit.oak.plugins.segment.MapEntry;
import org.apache.jackrabbit.oak.plugins.segment.Record;
import org.apache.jackrabbit.oak.plugins.segment.RecordId;
import org.apache.jackrabbit.oak.plugins.segment.Segment;
import org.apache.jackrabbit.oak.plugins.segment.SegmentNodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class MapRecord
extends Record {
    private static final int M = -554899859;
    private static final int A = 11;
    static final long HASH_MASK = 0xFFFFFFFFL;
    protected static final int BITS_PER_LEVEL = 5;
    protected static final int BUCKETS_PER_LEVEL = 32;
    protected static final int MAX_NUMBER_OF_LEVELS = 7;
    protected static final int LEVEL_BITS = Integer.numberOfTrailingZeros(Integer.highestOneBit(7) << 1);
    protected static final int SIZE_BITS = 32 - LEVEL_BITS;
    protected static final int MAX_SIZE = (1 << SIZE_BITS) - 1;

    static int getHash(String name) {
        return (name.hashCode() ^ 0xDEECE66D) * -554899859 + 11;
    }

    protected MapRecord(RecordId id) {
        super(id);
    }

    boolean isLeaf() {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getOffset(0));
        if (MapRecord.isDiff(head)) {
            RecordId base = segment.readRecordId(this.getOffset(8, 2));
            return new MapRecord(base).isLeaf();
        }
        return !MapRecord.isBranch(head);
    }

    public boolean isDiff() {
        return MapRecord.isDiff(this.getSegment().readInt(this.getOffset(0)));
    }

    MapRecord[] getBuckets() {
        Segment segment = this.getSegment();
        MapRecord[] buckets = new MapRecord[32];
        int bitmap = segment.readInt(this.getOffset(4));
        int ids = 0;
        for (int i = 0; i < 32; ++i) {
            buckets[i] = (bitmap & 1 << i) != 0 ? new MapRecord(segment.readRecordId(this.getOffset(8, ids++))) : null;
        }
        return buckets;
    }

    private List<MapRecord> getBucketList(Segment segment) {
        ArrayList buckets = Lists.newArrayListWithCapacity((int)32);
        int bitmap = segment.readInt(this.getOffset(4));
        int ids = 0;
        for (int i = 0; i < 32; ++i) {
            if ((bitmap & 1 << i) == 0) continue;
            RecordId id = segment.readRecordId(this.getOffset(8, ids++));
            buckets.add(new MapRecord(id));
        }
        return buckets;
    }

    int size() {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getOffset(0));
        if (MapRecord.isDiff(head)) {
            RecordId base = segment.readRecordId(this.getOffset(8, 2));
            return new MapRecord(base).size();
        }
        return MapRecord.getSize(head);
    }

    MapEntry getEntry(String name) {
        Preconditions.checkNotNull((Object)name);
        int hash = MapRecord.getHash(name);
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getOffset(0));
        if (MapRecord.isDiff(head)) {
            RecordId key;
            if (hash == segment.readInt(this.getOffset(4)) && name.equals(segment.readString(key = segment.readRecordId(this.getOffset(8))))) {
                RecordId value = segment.readRecordId(this.getOffset(8, 1));
                return new MapEntry(name, key, value);
            }
            RecordId base = segment.readRecordId(this.getOffset(8, 2));
            return new MapRecord(base).getEntry(name);
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return null;
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            int mask;
            int shift;
            int index;
            int bit;
            int bitmap = segment.readInt(this.getOffset(4));
            if ((bitmap & (bit = 1 << (index = hash >> (shift = 32 - (level + 1) * 5) & (mask = 31)))) != 0) {
                int ids = Integer.bitCount(bitmap & bit - 1);
                RecordId id = segment.readRecordId(this.getOffset(8, ids));
                return new MapRecord(id).getEntry(name);
            }
            return null;
        }
        int shift = 32 - level * 5;
        long mask = -1L << shift;
        long h = (long)hash & 0xFFFFFFFFL;
        int p = 0;
        long pH = h & mask;
        int q = size - 1;
        long qH = pH | mask ^ 0xFFFFFFFFFFFFFFFFL;
        while (p <= q) {
            assert (pH <= qH);
            int i = p + (int)((long)(q - p) * (h - pH) / (qH - pH));
            assert (p <= i && i <= q);
            long iH = (long)segment.readInt(this.getOffset(4 + i * 4)) & 0xFFFFFFFFL;
            int diff = Long.valueOf(iH).compareTo(h);
            if (diff == 0) {
                RecordId keyId = segment.readRecordId(this.getOffset(4 + size * 4, i * 2));
                RecordId valueId = segment.readRecordId(this.getOffset(4 + size * 4, i * 2 + 1));
                diff = segment.readString(keyId).compareTo(name);
                if (diff == 0) {
                    return new MapEntry(name, keyId, valueId);
                }
            }
            if (diff < 0) {
                p = i + 1;
                pH = iH;
                continue;
            }
            q = i - 1;
            qH = iH;
        }
        return null;
    }

    private RecordId getValue(int hash, RecordId key) {
        Preconditions.checkNotNull((Object)key);
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getOffset(0));
        if (MapRecord.isDiff(head)) {
            if (hash == segment.readInt(this.getOffset(4)) && key.equals(segment.readRecordId(this.getOffset(8)))) {
                return segment.readRecordId(this.getOffset(8, 1));
            }
            RecordId base = segment.readRecordId(this.getOffset(8, 2));
            return new MapRecord(base).getValue(hash, key);
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return null;
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            int mask;
            int shift;
            int index;
            int bit;
            int bitmap = segment.readInt(this.getOffset(4));
            if ((bitmap & (bit = 1 << (index = hash >> (shift = 32 - (level + 1) * 5) & (mask = 31)))) != 0) {
                int ids = Integer.bitCount(bitmap & bit - 1);
                RecordId id = segment.readRecordId(this.getOffset(8, ids));
                return new MapRecord(id).getValue(hash, key);
            }
            return null;
        }
        Long h = (long)hash & 0xFFFFFFFFL;
        for (int i = 0; i < size; ++i) {
            int keyOffset;
            int hashOffset = this.getOffset(4 + i * 4);
            int diff = h.compareTo((long)segment.readInt(hashOffset) & 0xFFFFFFFFL);
            if (diff > 0) {
                return null;
            }
            if (diff != 0 || !key.equals(segment.readRecordId(keyOffset = this.getOffset(4 + size * 4, i * 2)))) continue;
            int valueOffset = this.getOffset(4 + size * 4, i * 2 + 1);
            return segment.readRecordId(valueOffset);
        }
        return null;
    }

    Iterable<String> getKeys() {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getOffset(0));
        if (MapRecord.isDiff(head)) {
            RecordId base = segment.readRecordId(this.getOffset(8, 2));
            return new MapRecord(base).getKeys();
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return Collections.emptyList();
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            List<MapRecord> buckets = this.getBucketList(segment);
            ArrayList keys = Lists.newArrayListWithCapacity((int)buckets.size());
            for (MapRecord bucket : buckets) {
                keys.add(bucket.getKeys());
            }
            return Iterables.concat((Iterable)keys);
        }
        RecordId[] ids = new RecordId[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = segment.readRecordId(this.getOffset(4 + size * 4, i * 2));
        }
        String[] keys = new String[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = segment.readString(ids[i]);
        }
        return Arrays.asList(keys);
    }

    Iterable<MapEntry> getEntries() {
        return this.getEntries(null, null);
    }

    private Iterable<MapEntry> getEntries(RecordId diffKey, RecordId diffValue) {
        Segment segment = this.getSegment();
        int head = segment.readInt(this.getOffset(0));
        if (MapRecord.isDiff(head)) {
            RecordId key = segment.readRecordId(this.getOffset(8));
            RecordId value = segment.readRecordId(this.getOffset(8, 1));
            RecordId base = segment.readRecordId(this.getOffset(8, 2));
            return new MapRecord(base).getEntries(key, value);
        }
        int size = MapRecord.getSize(head);
        if (size == 0) {
            return Collections.emptyList();
        }
        int level = MapRecord.getLevel(head);
        if (MapRecord.isBranch(size, level)) {
            List<MapRecord> buckets = this.getBucketList(segment);
            ArrayList entries = Lists.newArrayListWithCapacity((int)buckets.size());
            for (MapRecord bucket : buckets) {
                entries.add(bucket.getEntries(diffKey, diffValue));
            }
            return Iterables.concat((Iterable)entries);
        }
        RecordId[] keys = new RecordId[size];
        RecordId[] values = new RecordId[size];
        for (int i = 0; i < size; ++i) {
            keys[i] = segment.readRecordId(this.getOffset(4 + size * 4, i * 2));
            values[i] = keys[i].equals(diffKey) ? diffValue : segment.readRecordId(this.getOffset(4 + size * 4, i * 2 + 1));
        }
        MapEntry[] entries = new MapEntry[size];
        for (int i = 0; i < size; ++i) {
            String name = segment.readString(keys[i]);
            entries[i] = new MapEntry(name, keys[i], values[i]);
        }
        return Arrays.asList(entries);
    }

    boolean compare(MapRecord before, NodeStateDiff diff) {
        Segment beforeSegment = before.getSegment();
        int beforeHead = beforeSegment.readInt(before.getOffset(0));
        MapRecord after = this;
        Segment afterSegment = after.getSegment();
        int afterHead = afterSegment.readInt(after.getOffset(0));
        if (MapRecord.isDiff(afterHead)) {
            RecordId beforeBase;
            RecordId base = afterSegment.readRecordId(after.getOffset(8, 2));
            if (base.equals(after.getRecordId())) {
                int hash = afterSegment.readInt(after.getOffset(4));
                RecordId key = afterSegment.readRecordId(after.getOffset(8));
                RecordId afterValue = afterSegment.readRecordId(after.getOffset(8, 1));
                RecordId beforeValue = before.getValue(hash, key);
                String name = beforeSegment.readString(key);
                return diff.childNodeChanged(name, new SegmentNodeState(beforeValue), new SegmentNodeState(afterValue));
            }
            if (MapRecord.isDiff(beforeHead) && base.equals(beforeBase = beforeSegment.readRecordId(before.getOffset(8, 2)))) {
                int beforeHash = beforeSegment.readInt(before.getOffset(4));
                RecordId beforeKey = beforeSegment.readRecordId(before.getOffset(8));
                RecordId beforeValue = beforeSegment.readRecordId(before.getOffset(8, 1));
                int afterHash = afterSegment.readInt(after.getOffset(4));
                RecordId afterKey = afterSegment.readRecordId(after.getOffset(8));
                RecordId afterValue = afterSegment.readRecordId(after.getOffset(8, 1));
                if (beforeKey.equals(afterKey)) {
                    String name = beforeSegment.readString(beforeKey);
                    return diff.childNodeChanged(name, new SegmentNodeState(beforeValue), new SegmentNodeState(afterValue));
                }
                String beforeName = beforeSegment.readString(beforeKey);
                String afterName = afterSegment.readString(afterKey);
                return diff.childNodeChanged(beforeName, new SegmentNodeState(beforeValue), new SegmentNodeState(after.getValue(beforeHash, beforeKey))) && diff.childNodeChanged(afterName, new SegmentNodeState(before.getValue(afterHash, afterKey)), new SegmentNodeState(afterValue));
            }
        } else if (MapRecord.isBranch(beforeHead) && MapRecord.isBranch(afterHead)) {
            return MapRecord.compareBranch(before, after, diff);
        }
        Iterator<MapEntry> beforeEntries = before.getEntries().iterator();
        Iterator<MapEntry> afterEntries = after.getEntries().iterator();
        MapEntry beforeEntry = MapRecord.nextOrNull(beforeEntries);
        MapEntry afterEntry = MapRecord.nextOrNull(afterEntries);
        while (beforeEntry != null || afterEntry != null) {
            int d = MapRecord.compare(beforeEntry, afterEntry);
            if (d < 0) {
                if (!diff.childNodeDeleted(beforeEntry.getName(), beforeEntry.getNodeState())) {
                    return false;
                }
                beforeEntry = MapRecord.nextOrNull(beforeEntries);
                continue;
            }
            if (d == 0) {
                if (!beforeEntry.getValue().equals(afterEntry.getValue()) && !diff.childNodeChanged(beforeEntry.getName(), beforeEntry.getNodeState(), afterEntry.getNodeState())) {
                    return false;
                }
                beforeEntry = MapRecord.nextOrNull(beforeEntries);
                afterEntry = MapRecord.nextOrNull(afterEntries);
                continue;
            }
            if (!diff.childNodeAdded(afterEntry.getName(), afterEntry.getNodeState())) {
                return false;
            }
            afterEntry = MapRecord.nextOrNull(afterEntries);
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuilder builder = null;
        for (MapEntry entry : this.getEntries()) {
            if (builder == null) {
                builder = new StringBuilder("{ ");
            } else {
                builder.append(", ");
            }
            builder.append(entry);
        }
        if (builder == null) {
            return "{}";
        }
        builder.append(" }");
        return builder.toString();
    }

    private static boolean compareBranch(MapRecord before, MapRecord after, NodeStateDiff diff) {
        MapRecord[] beforeBuckets = before.getBuckets();
        MapRecord[] afterBuckets = after.getBuckets();
        for (int i = 0; i < 32; ++i) {
            MapRecord bucket;
            if (Objects.equal((Object)beforeBuckets[i], (Object)afterBuckets[i])) continue;
            if (beforeBuckets[i] == null) {
                bucket = afterBuckets[i];
                for (MapEntry entry : bucket.getEntries()) {
                    if (diff.childNodeAdded(entry.getName(), entry.getNodeState())) continue;
                    return false;
                }
                continue;
            }
            if (afterBuckets[i] == null) {
                bucket = beforeBuckets[i];
                for (MapEntry entry : bucket.getEntries()) {
                    if (diff.childNodeDeleted(entry.getName(), entry.getNodeState())) continue;
                    return false;
                }
                continue;
            }
            MapRecord afterBucket = afterBuckets[i];
            MapRecord beforeBucket = beforeBuckets[i];
            if (afterBucket.compare(beforeBucket, diff)) continue;
            return false;
        }
        return true;
    }

    private static int getSize(int head) {
        return head & (1 << SIZE_BITS) - 1;
    }

    private static int getLevel(int head) {
        return head >>> SIZE_BITS;
    }

    private static boolean isDiff(int head) {
        return head == -1;
    }

    private static boolean isBranch(int head) {
        return MapRecord.isBranch(MapRecord.getSize(head), MapRecord.getLevel(head));
    }

    private static boolean isBranch(int size, int level) {
        return size > 32 && level < 7;
    }

    private static int compare(MapEntry before, MapEntry after) {
        if (before == null) {
            return 1;
        }
        if (after == null) {
            return -1;
        }
        return ComparisonChain.start().compare((long)before.getHash() & 0xFFFFFFFFL, (long)after.getHash() & 0xFFFFFFFFL).compare((Comparable)((Object)before.getName()), (Comparable)((Object)after.getName())).result();
    }

    private static MapEntry nextOrNull(Iterator<MapEntry> iterator) {
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

