/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.util;

import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.mk.api.MicroKernel;
import org.apache.jackrabbit.mk.api.MicroKernelException;

public class TimingWrapper
implements MicroKernel {
    private static final boolean DEBUG = Boolean.parseBoolean(System.getProperty("mk.debug", "true"));
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    private final MicroKernel mk;
    private final int id = NEXT_ID.getAndIncrement();
    private long startTime;
    private final Map<String, Count> counts = new HashMap<String, Count>();
    private long lastLogTime;
    private long totalLogTime;

    public TimingWrapper(MicroKernel mk) {
        this.mk = mk;
        this.lastLogTime = TimingWrapper.now();
    }

    public String commit(String path, String jsonDiff, String revisionId, String message) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.commit(path, jsonDiff, revisionId, message);
            this.updateAndLogTimes("commit", start, TimingWrapper.size(path) + TimingWrapper.size(jsonDiff) + TimingWrapper.size(message), 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String getHeadRevision() {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.getHeadRevision();
            this.updateAndLogTimes("getHeadRevision", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    @Nonnull
    public String checkpoint(long lifetime) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.checkpoint(lifetime);
            this.updateAndLogTimes("checkpoint", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String getJournal(String fromRevisionId, String toRevisionId, String path) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.getJournal(fromRevisionId, toRevisionId, path);
            this.updateAndLogTimes("getJournal", start, TimingWrapper.size(path), TimingWrapper.size(result));
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String diff(String fromRevisionId, String toRevisionId, String path, int depth) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.diff(fromRevisionId, toRevisionId, path, depth);
            this.updateAndLogTimes("diff", start, TimingWrapper.size(path), TimingWrapper.size(result));
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public long getLength(String blobId) {
        try {
            long start = TimingWrapper.now();
            long result = this.mk.getLength(blobId);
            this.updateAndLogTimes("getLength", start, TimingWrapper.size(blobId), 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String getNodes(String path, String revisionId, int depth, long offset, int maxChildNodes, String filter) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.getNodes(path, revisionId, depth, offset, maxChildNodes, filter);
            this.updateAndLogTimes("getNodes", start, TimingWrapper.size(path) + TimingWrapper.size(filter), TimingWrapper.size(result));
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String getRevisionHistory(long since, int maxEntries, String path) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.getRevisionHistory(since, maxEntries, path);
            this.updateAndLogTimes("getRevisionHistory", start, TimingWrapper.size(path), TimingWrapper.size(result));
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public boolean nodeExists(String path, String revisionId) {
        try {
            long start = TimingWrapper.now();
            boolean result = this.mk.nodeExists(path, revisionId);
            this.updateAndLogTimes("nodeExists", start, TimingWrapper.size(path), 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public long getChildNodeCount(String path, String revisionId) {
        try {
            long start = TimingWrapper.now();
            long result = this.mk.getChildNodeCount(path, revisionId);
            this.updateAndLogTimes("getChildNodeCount", start, TimingWrapper.size(path), 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public int read(String blobId, long pos, byte[] buff, int off, int length) {
        try {
            long start = TimingWrapper.now();
            int result = this.mk.read(blobId, pos, buff, off, length);
            this.updateAndLogTimes("read", start, TimingWrapper.size(blobId) + length, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String waitForCommit(String oldHeadRevisionId, long maxWaitMillis) throws InterruptedException {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.waitForCommit(oldHeadRevisionId, maxWaitMillis);
            this.updateAndLogTimes("waitForCommit", start, 0, 0);
            return result;
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String write(InputStream in) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.write(in);
            this.updateAndLogTimes("write", start, 0, TimingWrapper.size(result));
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String branch(String trunkRevisionId) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.branch(trunkRevisionId);
            this.updateAndLogTimes("branch", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    public String merge(String branchRevisionId, String message) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.merge(branchRevisionId, message);
            this.updateAndLogTimes("merge", start, TimingWrapper.size(message), 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    @Nonnull
    public String rebase(@Nonnull String branchRevisionId, String newBaseRevisionId) {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.rebase(branchRevisionId, newBaseRevisionId);
            this.updateAndLogTimes("rebase", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    @Nonnull
    public String reset(@Nonnull String branchRevisionId, @Nonnull String ancestorRevisionId) throws MicroKernelException {
        try {
            long start = TimingWrapper.now();
            String result = this.mk.reset(branchRevisionId, ancestorRevisionId);
            this.updateAndLogTimes("reset", start, 0, 0);
            return result;
        }
        catch (Exception e) {
            throw TimingWrapper.convert(e);
        }
    }

    private static RuntimeException convert(Exception e) {
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        return new MicroKernelException("Unexpected exception: " + e.toString(), (Throwable)e);
    }

    private void log(String message) {
        if (DEBUG) {
            System.out.println("[" + this.id + "] " + message);
        }
    }

    private static int size(String s) {
        return s == null ? 0 : s.length();
    }

    private static long now() {
        return System.currentTimeMillis();
    }

    private void updateAndLogTimes(String operation, long start, int paramSize, int resultSize) {
        Count c;
        long now = TimingWrapper.now();
        if (this.startTime == 0L) {
            this.startTime = now;
        }
        if ((c = this.counts.get(operation)) == null) {
            c = new Count();
            this.counts.put(operation, c);
        }
        c.update(now - start, paramSize, resultSize);
        long t = now - this.lastLogTime;
        if (t >= 2000L) {
            this.totalLogTime += t;
            this.lastLogTime = now;
            long totalCount = 0L;
            long totalTime = 0L;
            for (Count count : this.counts.values()) {
                totalCount += count.count;
                totalTime += count.total;
            }
            totalCount = Math.max(1L, totalCount);
            totalTime = Math.max(1L, totalTime);
            for (Map.Entry entry : this.counts.entrySet()) {
                c = (Count)entry.getValue();
                long count = c.count;
                long total = c.total;
                long in = c.paramSize / 1024L / 1024L;
                long out = c.resultSize / 1024L / 1024L;
                if (count <= 0L) continue;
                this.log((String)entry.getKey() + " count " + count + " " + 100L * count / totalCount + "%" + " in " + in + " out " + out + " time " + total + " " + 100L * total / totalTime + "%");
            }
            this.log("all count " + totalCount + " time " + totalTime + " " + 100L * totalTime / this.totalLogTime + "%");
            this.log("------");
        }
    }

    static class Count {
        public long count;
        public long max;
        public long total;
        public long paramSize;
        public long resultSize;

        Count() {
        }

        void update(long time, int paramSize, int resultSize) {
            ++this.count;
            if (time > this.max) {
                this.max = time;
            }
            this.total += time;
            this.paramSize += (long)paramSize;
            this.resultSize += (long)resultSize;
        }
    }
}

