/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document.cache;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.Closeable;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class KryoSerializer
implements Closeable {
    private static final int BUFFER_SIZE = 1024;
    private final KryoPool pool;

    public KryoSerializer(KryoPool pool) {
        this.pool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> byte[] serialize(T obj) throws IOException {
        KryoHolder kh = null;
        try {
            kh = this.pool.get();
            kh.reset();
            kh.kryo.writeObject(kh.output, obj);
            byte[] byArray = kh.output.toBytes();
            return byArray;
        }
        finally {
            if (kh != null) {
                this.pool.done(kh);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(byte[] source, Class<T> clazz) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        KryoHolder kh = null;
        try {
            kh = this.pool.get();
            Input input = new Input(source);
            Object object = kh.kryo.readObject(input, clazz);
            return (T)object;
        }
        finally {
            if (kh != null) {
                this.pool.done(kh);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.pool.close();
    }

    public static class KryoPool {
        private final Queue<KryoHolder> objects = new ConcurrentLinkedQueue<KryoHolder>();

        public KryoHolder get() {
            KryoHolder kh = this.objects.poll();
            if (kh == null) {
                kh = new KryoHolder(this.createInstance());
            }
            return kh;
        }

        public void done(KryoHolder kh) {
            this.objects.offer(kh);
        }

        public void close() {
            this.objects.clear();
        }

        protected Kryo createInstance() {
            Kryo kryo = new Kryo();
            kryo.setReferences(false);
            return kryo;
        }
    }

    private static class KryoHolder {
        final Kryo kryo;
        final Output output = new Output(1024, -1);

        KryoHolder(Kryo kryo) {
            this.kryo = kryo;
        }

        private void reset() {
            this.output.clear();
        }
    }
}

