/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.plugins.document.Revision;

public final class PathRev
implements CacheValue {
    private final String path;
    private final Revision revision;

    public PathRev(@Nonnull String path, @Nonnull Revision revision) {
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.revision = (Revision)Preconditions.checkNotNull((Object)revision);
    }

    @Override
    public int getMemory() {
        return 64 + this.path.length() * 2 + 32;
    }

    public int hashCode() {
        return this.path.hashCode() ^ this.revision.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PathRev) {
            PathRev other = (PathRev)obj;
            return this.revision.equals(other.revision) && this.path.equals(other.path);
        }
        return false;
    }

    public String toString() {
        return this.path + "@" + this.revision;
    }
}

