/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.plugins.document;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.api.Type;
import org.apache.jackrabbit.oak.cache.CacheValue;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.commons.json.JsopBuilder;
import org.apache.jackrabbit.oak.commons.json.JsopTokenizer;
import org.apache.jackrabbit.oak.commons.json.JsopWriter;
import org.apache.jackrabbit.oak.kernel.JsonSerializer;
import org.apache.jackrabbit.oak.plugins.document.Branch;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStore;
import org.apache.jackrabbit.oak.plugins.document.DocumentNodeStoreBranch;
import org.apache.jackrabbit.oak.plugins.document.DocumentPropertyState;
import org.apache.jackrabbit.oak.plugins.document.DocumentRootBuilder;
import org.apache.jackrabbit.oak.plugins.document.NodeDocument;
import org.apache.jackrabbit.oak.plugins.document.Revision;
import org.apache.jackrabbit.oak.plugins.document.UpdateOp;
import org.apache.jackrabbit.oak.plugins.document.util.Utils;
import org.apache.jackrabbit.oak.plugins.memory.EmptyNodeState;
import org.apache.jackrabbit.oak.plugins.memory.MemoryNodeBuilder;
import org.apache.jackrabbit.oak.plugins.memory.ModifiedNodeState;
import org.apache.jackrabbit.oak.spi.state.AbstractChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.AbstractNodeState;
import org.apache.jackrabbit.oak.spi.state.ChildNodeEntry;
import org.apache.jackrabbit.oak.spi.state.EqualsDiff;
import org.apache.jackrabbit.oak.spi.state.NodeBuilder;
import org.apache.jackrabbit.oak.spi.state.NodeState;
import org.apache.jackrabbit.oak.spi.state.NodeStateDiff;

class DocumentNodeState
extends AbstractNodeState
implements CacheValue {
    public static final Children NO_CHILDREN = new Children();
    static final int INITIAL_FETCH_SIZE = 100;
    static final int MAX_FETCH_SIZE = 1600;
    final String path;
    final Revision rev;
    final Map<String, PropertyState> properties = Maps.newHashMap();
    Revision lastRevision;
    final boolean hasChildren;
    private final DocumentNodeStore store;

    DocumentNodeState(@Nonnull DocumentNodeStore store, @Nonnull String path, @Nonnull Revision rev) {
        this(store, path, rev, false);
    }

    DocumentNodeState(@Nonnull DocumentNodeStore store, @Nonnull String path, @Nonnull Revision rev, boolean hasChildren) {
        this.store = (DocumentNodeStore)Preconditions.checkNotNull((Object)store);
        this.path = (String)Preconditions.checkNotNull((Object)path);
        this.rev = (Revision)Preconditions.checkNotNull((Object)rev);
        this.hasChildren = hasChildren;
    }

    Revision getRevision() {
        return this.rev;
    }

    @Override
    public boolean equals(Object that) {
        ModifiedNodeState modified;
        if (this == that) {
            return true;
        }
        if (that instanceof DocumentNodeState) {
            DocumentNodeState other = (DocumentNodeState)that;
            if (this.getPath().equals(other.getPath())) {
                return this.lastRevision.equals(other.lastRevision);
            }
        } else if (that instanceof ModifiedNodeState && (modified = (ModifiedNodeState)that).getBaseState() == this) {
            return EqualsDiff.equals(this, modified);
        }
        if (that instanceof NodeState) {
            return AbstractNodeState.equals(this, (NodeState)that);
        }
        return false;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public PropertyState getProperty(String name) {
        return this.properties.get(name);
    }

    @Override
    public boolean hasProperty(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    @Nonnull
    public Iterable<? extends PropertyState> getProperties() {
        return this.properties.values();
    }

    @Override
    public boolean hasChildNode(String name) {
        if (!this.hasChildren || !DocumentNodeState.isValidName(name)) {
            return false;
        }
        String p = PathUtils.concat((String)this.getPath(), (String)name);
        return this.store.getNode(p, this.lastRevision) != null;
    }

    @Override
    @Nonnull
    public NodeState getChildNode(@Nonnull String name) {
        if (!this.hasChildren) {
            DocumentNodeState.checkValidName(name);
            return EmptyNodeState.MISSING_NODE;
        }
        String p = PathUtils.concat((String)this.getPath(), (String)name);
        DocumentNodeState child = this.store.getNode(p, this.lastRevision);
        if (child == null) {
            DocumentNodeState.checkValidName(name);
            return EmptyNodeState.MISSING_NODE;
        }
        return child;
    }

    @Override
    public long getChildNodeCount(long max) {
        if (!this.hasChildren) {
            return 0L;
        }
        if (max > (long)DocumentNodeStore.NUM_CHILDREN_CACHE_LIMIT) {
            return Iterators.size((Iterator)new ChildNodeEntryIterator());
        }
        Children c = this.store.getChildren(this, null, (int)max);
        if (c.hasMore) {
            return Long.MAX_VALUE;
        }
        return c.children.size();
    }

    @Override
    @Nonnull
    public Iterable<? extends ChildNodeEntry> getChildNodeEntries() {
        if (!this.hasChildren) {
            return Collections.emptyList();
        }
        return new Iterable<ChildNodeEntry>(){

            @Override
            public Iterator<ChildNodeEntry> iterator() {
                return new ChildNodeEntryIterator();
            }
        };
    }

    @Override
    @Nonnull
    public NodeBuilder builder() {
        if ("/".equals(this.getPath())) {
            if (this.rev.isBranch()) {
                Branch b = this.store.getBranches().getBranch(this.rev);
                if (b == null) {
                    if (this.store.isDisableBranches()) {
                        if (DocumentNodeStoreBranch.getCurrentBranch() != null) {
                            return new DocumentRootBuilder(this, this.store);
                        }
                        return new MemoryNodeBuilder(this);
                    }
                    throw new IllegalStateException("No branch for revision: " + this.rev);
                }
                if (b.isHead(this.rev) && DocumentNodeStoreBranch.getCurrentBranch() != null) {
                    return new DocumentRootBuilder(this, this.store);
                }
                return new MemoryNodeBuilder(this);
            }
            return new DocumentRootBuilder(this, this.store);
        }
        return new MemoryNodeBuilder(this);
    }

    @Override
    public boolean compareAgainstBaseState(NodeState base, NodeStateDiff diff) {
        if (this == base) {
            return true;
        }
        if (base == EmptyNodeState.EMPTY_NODE || !base.exists()) {
            return EmptyNodeState.compareAgainstEmptyState(this, diff);
        }
        if (base instanceof DocumentNodeState) {
            DocumentNodeState mBase = (DocumentNodeState)base;
            if (this.store == mBase.store && this.getPath().equals(mBase.getPath())) {
                if (this.lastRevision.equals(mBase.lastRevision)) {
                    return true;
                }
                return this.dispatch(this.store.diffChildren(this, mBase), mBase, diff);
            }
        }
        return super.compareAgainstBaseState(base, diff);
    }

    void setProperty(String propertyName, String value) {
        if (value == null) {
            this.properties.remove(propertyName);
        } else {
            this.properties.put(propertyName, new DocumentPropertyState(this.store, propertyName, value));
        }
    }

    void setProperty(PropertyState property) {
        this.properties.put(property.getName(), property);
    }

    String getPropertyAsString(String propertyName) {
        PropertyState prop = this.properties.get(propertyName);
        if (prop == null) {
            return null;
        }
        JsopBuilder builder = new JsopBuilder();
        new JsonSerializer(builder, this.store.getBlobSerializer()).serialize(prop);
        return builder.toString();
    }

    Set<String> getPropertyNames() {
        return this.properties.keySet();
    }

    void copyTo(DocumentNodeState newNode) {
        newNode.properties.putAll(this.properties);
    }

    boolean hasNoChildren() {
        return !this.hasChildren;
    }

    @Override
    public String toString() {
        StringBuilder buff = new StringBuilder();
        buff.append("path: ").append(this.path).append('\n');
        buff.append("rev: ").append(this.rev).append('\n');
        buff.append(this.properties);
        buff.append('\n');
        return buff.toString();
    }

    UpdateOp asOperation(boolean isNew) {
        String id = Utils.getIdFromPath(this.path);
        UpdateOp op = new UpdateOp(id, isNew);
        op.set("_id", id);
        if (Utils.isLongPath(this.path)) {
            op.set("_path", this.path);
        }
        NodeDocument.setModified(op, this.rev);
        NodeDocument.setDeleted(op, this.rev, false);
        for (String p : this.properties.keySet()) {
            String key = Utils.escapePropertyName(p);
            op.setMapEntry(key, this.rev, this.getPropertyAsString(p));
        }
        return op;
    }

    String getPath() {
        return this.path;
    }

    String getId() {
        return this.path + "@" + this.lastRevision;
    }

    void append(JsopWriter json, boolean includeId) {
        if (includeId) {
            json.key(":id").value(this.getId());
        }
        for (String p : this.properties.keySet()) {
            json.key(p).encodedValue(this.getPropertyAsString(p));
        }
    }

    void setLastRevision(Revision lastRevision) {
        this.lastRevision = lastRevision;
    }

    Revision getLastRevision() {
        return this.lastRevision;
    }

    @Override
    public int getMemory() {
        int size = 180 + this.path.length() * 2;
        for (Map.Entry<String, PropertyState> entry : this.properties.entrySet()) {
            size += 48 + entry.getKey().length() * 2;
            PropertyState propState = entry.getValue();
            if (propState.getType() == Type.BINARY || propState.getType() == Type.BINARIES) continue;
            for (int i = 0; i < propState.count(); ++i) {
                size = (int)((long)size + (56L + propState.size(i) * 2L));
            }
        }
        return size;
    }

    private boolean dispatch(@Nonnull String jsonDiff, @Nonnull DocumentNodeState base, @Nonnull NodeStateDiff diff) {
        int r;
        if (!AbstractNodeState.comparePropertiesAgainstBaseState(this, base, diff)) {
            return false;
        }
        if (jsonDiff.trim().isEmpty()) {
            return true;
        }
        JsopTokenizer t = new JsopTokenizer(jsonDiff);
        boolean continueComparison = true;
        block5: while (continueComparison && (r = t.read()) != 0) {
            switch (r) {
                case 43: {
                    String name = t.readString();
                    t.read(58);
                    t.read(123);
                    while (t.read() != 125) {
                    }
                    continueComparison = diff.childNodeAdded(name, this.getChildNode(name));
                    continue block5;
                }
                case 45: {
                    String name = t.readString();
                    continueComparison = diff.childNodeDeleted(name, base.getChildNode(name));
                    continue block5;
                }
                case 94: {
                    String name = t.readString();
                    t.read(58);
                    if (t.matches(123)) {
                        t.read(125);
                        continueComparison = diff.childNodeChanged(name, base.getChildNode(name), this.getChildNode(name));
                        continue block5;
                    }
                    if (t.matches(91)) {
                        while (t.read() != 93) {
                        }
                        continue block5;
                    }
                    t.read();
                    continue block5;
                }
            }
            throw new IllegalArgumentException("jsonDiff: illegal token '" + t.getToken() + "' at pos: " + t.getLastPos() + ' ' + jsonDiff);
        }
        return continueComparison;
    }

    @Nonnull
    private Iterable<ChildNodeEntry> getChildNodeEntries(@Nullable String name, int limit) {
        Iterable<DocumentNodeState> children = this.store.getChildNodes(this, name, limit);
        return Iterables.transform(children, (Function)new Function<DocumentNodeState, ChildNodeEntry>(){

            public ChildNodeEntry apply(final DocumentNodeState input) {
                return new AbstractChildNodeEntry(){

                    @Override
                    @Nonnull
                    public String getName() {
                        return PathUtils.getName((String)input.getPath());
                    }

                    @Override
                    @Nonnull
                    public NodeState getNodeState() {
                        return input;
                    }
                };
            }
        });
    }

    private class ChildNodeEntryIterator
    implements Iterator<ChildNodeEntry> {
        private String previousName;
        private Iterator<ChildNodeEntry> current;
        private int fetchSize;
        private int currentRemaining;

        ChildNodeEntryIterator() {
            this.currentRemaining = this.fetchSize = 100;
            this.fetchMore();
        }

        @Override
        public boolean hasNext() {
            while (this.current != null) {
                if (this.current.hasNext()) {
                    return true;
                }
                if (this.currentRemaining > 0) {
                    return false;
                }
                this.fetchMore();
            }
            return false;
        }

        @Override
        public ChildNodeEntry next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ChildNodeEntry entry = this.current.next();
            this.previousName = entry.getName();
            --this.currentRemaining;
            return entry;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void fetchMore() {
            Iterator entries = DocumentNodeState.this.getChildNodeEntries(this.previousName, this.fetchSize).iterator();
            this.currentRemaining = this.fetchSize;
            this.fetchSize = Math.min(this.fetchSize * 2, 1600);
            this.current = entries.hasNext() ? entries : null;
        }
    }

    public static class Children
    implements CacheValue {
        final ArrayList<String> children = new ArrayList();
        boolean hasMore;

        @Override
        public int getMemory() {
            int size = 114;
            for (String c : this.children) {
                size += c.length() * 2 + 56;
            }
            return size;
        }

        public String toString() {
            return this.children.toString();
        }
    }
}

