/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.osgi;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.jackrabbit.oak.spi.whiteboard.Registration;
import org.apache.jackrabbit.oak.spi.whiteboard.Tracker;
import org.apache.jackrabbit.oak.spi.whiteboard.Whiteboard;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class OsgiWhiteboard
implements Whiteboard {
    private final BundleContext context;

    public OsgiWhiteboard(@Nonnull BundleContext context) {
        this.context = (BundleContext)Preconditions.checkNotNull((Object)context);
    }

    @Override
    public <T> Registration register(Class<T> type, T service, Map<?, ?> properties) {
        Preconditions.checkNotNull(type);
        Preconditions.checkNotNull(service);
        Preconditions.checkNotNull(properties);
        Preconditions.checkArgument((boolean)type.isInstance(service));
        Hashtable dictionary = new Hashtable();
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            ((Dictionary)dictionary).put(entry.getKey(), entry.getValue());
        }
        final ServiceRegistration registration = this.context.registerService(type.getName(), service, dictionary);
        return new Registration(){

            @Override
            public void unregister() {
                registration.unregister();
            }
        };
    }

    @Override
    public <T> Tracker<T> track(Class<T> type) {
        Preconditions.checkNotNull(type);
        final ServiceTracker tracker = new ServiceTracker(this.context, type.getName(), null);
        tracker.open();
        return new Tracker<T>(){

            @Override
            public List<T> getServices() {
                Object[] services = tracker.getServices();
                return services != null ? Arrays.asList(services) : Collections.emptyList();
            }

            @Override
            public void stop() {
                tracker.close();
            }
        };
    }
}

