/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.posix.FileStat;
import org.jruby.ext.posix.util.Platform;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

@JRubyClass(name={"File::Stat"}, include={"Comparable"})
public class RubyFileStat
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final int S_IRUGO = 292;
    private static final int S_IWUGO = 146;
    private static final int S_IXUGO = 73;
    private JRubyFile file;
    private FileStat stat;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            return new RubyFileStat(runtime2, klass);
        }
    };

    public static RubyClass createFileStatClass(Ruby runtime2) {
        RubyClass fileStatClass = runtime2.getFile().defineClassUnder("Stat", runtime2.getObject(), ALLOCATOR);
        runtime2.setFileStat(fileStatClass);
        fileStatClass.includeModule(runtime2.fastGetModule("Comparable"));
        fileStatClass.defineAnnotatedMethods(RubyFileStat.class);
        return fileStatClass;
    }

    protected RubyFileStat(Ruby runtime2, RubyClass clazz) {
        super(runtime2, clazz);
    }

    public static RubyFileStat newFileStat(Ruby runtime2, String filename2, boolean lstat2) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(filename2, lstat2);
        return stat2;
    }

    public static RubyFileStat newFileStat(Ruby runtime2, FileDescriptor descriptor) {
        RubyFileStat stat2 = new RubyFileStat(runtime2, runtime2.getFileStat());
        stat2.setup(descriptor);
        return stat2;
    }

    private void setup(FileDescriptor descriptor) {
        this.stat = this.getRuntime().getPosix().fstat(descriptor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setup(String filename2, boolean lstat2) {
        if (Platform.IS_WINDOWS && filename2.length() == 2 && filename2.charAt(1) == ':' && Character.isLetter(filename2.charAt(0))) {
            filename2 = filename2 + "/";
        }
        if (filename2.startsWith("file:") && filename2.indexOf(33) != -1) {
            String zipFileEntry = filename2.substring(filename2.indexOf("!") + 1);
            if (zipFileEntry.length() <= 0) throw this.getRuntime().newErrnoENOENTError("invalid jar/file URL: " + filename2);
            if (zipFileEntry.charAt(0) == '/') {
                if (zipFileEntry.length() <= 1) throw this.getRuntime().newErrnoENOENTError("invalid jar/file URL: " + filename2);
                zipFileEntry = zipFileEntry.substring(1);
            }
            String zipfilename = filename2.substring(5, filename2.indexOf("!"));
            try {
                ZipFile zipFile = new ZipFile(zipfilename);
                ZipEntry zipEntry = RubyFile.getFileEntry(zipFile, zipFileEntry);
                if (zipEntry == null) {
                    throw this.getRuntime().newErrnoENOENTError("invalid jar/file URL: " + filename2);
                }
                this.stat = new ZipFileStat(zipEntry);
                return;
            }
            catch (IOException ioe) {
                filename2 = zipfilename;
            }
        }
        this.file = JRubyFile.create(this.getRuntime().getCurrentDirectory(), filename2);
        this.stat = lstat2 ? this.getRuntime().getPosix().lstat(this.file.getAbsolutePath()) : this.getRuntime().getPosix().stat(this.file.getAbsolutePath());
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        this.setup(fname.convertToString().toString(), false);
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject fname, Block unusedBlock) {
        if (!(fname instanceof RubyString) && fname.respondsTo("to_path")) {
            fname = fname.callMethod(this.getRuntime().getCurrentContext(), "to_path");
        }
        return this.initialize(fname, unusedBlock);
    }

    @JRubyMethod(name={"atime"})
    public IRubyObject atime() {
        return this.getRuntime().newTime(this.stat.atime() * 1000L);
    }

    @JRubyMethod(name={"blksize"})
    public RubyFixnum blksize() {
        return this.getRuntime().newFixnum(this.stat.blockSize());
    }

    @JRubyMethod(name={"blockdev?"})
    public IRubyObject blockdev_p() {
        return this.getRuntime().newBoolean(this.stat.isBlockDev());
    }

    @JRubyMethod(name={"blocks"})
    public IRubyObject blocks() {
        return this.getRuntime().newFixnum(this.stat.blocks());
    }

    @JRubyMethod(name={"chardev?"})
    public IRubyObject chardev_p() {
        return this.getRuntime().newBoolean(this.stat.isCharDev());
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject cmp(IRubyObject other) {
        long time2;
        long time1;
        if (!(other instanceof RubyFileStat)) {
            this.getRuntime().getNil();
        }
        if ((time1 = this.stat.mtime()) == (time2 = ((RubyFileStat)other).stat.mtime())) {
            return this.getRuntime().newFixnum(0);
        }
        if (time1 < time2) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().newFixnum(1);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime() {
        return this.getRuntime().newTime(this.stat.ctime() * 1000L);
    }

    @JRubyMethod(name={"dev"})
    public IRubyObject dev() {
        return this.getRuntime().newFixnum(this.stat.dev());
    }

    @JRubyMethod(name={"dev_major"})
    public IRubyObject devMajor() {
        return this.getRuntime().newFixnum(this.stat.major(this.stat.dev()));
    }

    @JRubyMethod(name={"dev_minor"})
    public IRubyObject devMinor() {
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.dev()));
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p() {
        return this.getRuntime().newBoolean(this.stat.isDirectory());
    }

    @JRubyMethod(name={"executable?"})
    public IRubyObject executable_p() {
        return this.getRuntime().newBoolean(this.stat.isExecutable());
    }

    @JRubyMethod(name={"executable_real?"})
    public IRubyObject executableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isExecutableReal());
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p() {
        return this.getRuntime().newBoolean(this.stat.isFile());
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype() {
        return this.getRuntime().newString(this.stat.ftype());
    }

    @JRubyMethod(name={"gid"})
    public IRubyObject gid() {
        return this.getRuntime().newFixnum(this.stat.gid());
    }

    @JRubyMethod(name={"grpowned?"})
    public IRubyObject group_owned_p() {
        return this.getRuntime().newBoolean(this.stat.isGroupOwned());
    }

    @JRubyMethod(name={"initialize_copy"}, required=1)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyFileStat)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyFileStat originalFileStat = (RubyFileStat)original;
        this.file = originalFileStat.file;
        this.stat = originalFileStat.stat;
        return this;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino() {
        return this.getRuntime().newFixnum(this.stat.ino());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder buf;
        block39: {
            block38: {
                block37: {
                    block36: {
                        block35: {
                            block34: {
                                block33: {
                                    block32: {
                                        buf = new StringBuilder("#<");
                                        buf.append(this.getMetaClass().getRealClass().getName());
                                        buf.append(" ");
                                        try {
                                            try {
                                                buf.append("dev=0x").append(Long.toHexString(this.stat.dev()));
                                            }
                                            catch (Exception e) {
                                                Object var4_3 = null;
                                                buf.append(", ");
                                                break block32;
                                            }
                                            Object var4_2 = null;
                                            buf.append(", ");
                                        }
                                        catch (Throwable throwable) {
                                            Object var4_4 = null;
                                            buf.append(", ");
                                            throw throwable;
                                        }
                                    }
                                    try {
                                        try {
                                            buf.append("ino=").append(this.stat.ino());
                                        }
                                        catch (Exception e) {
                                            Object var6_15 = null;
                                            buf.append(", ");
                                            break block33;
                                        }
                                        Object var6_14 = null;
                                        buf.append(", ");
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_16 = null;
                                        buf.append(", ");
                                        throw throwable;
                                    }
                                }
                                buf.append("mode=0").append(Integer.toOctalString(this.stat.mode())).append(", ");
                                try {
                                    try {
                                        buf.append("nlink=").append(this.stat.nlink());
                                    }
                                    catch (Exception e) {
                                        Object var8_19 = null;
                                        buf.append(", ");
                                        break block34;
                                    }
                                    Object var8_18 = null;
                                    buf.append(", ");
                                }
                                catch (Throwable throwable) {
                                    Object var8_20 = null;
                                    buf.append(", ");
                                    throw throwable;
                                }
                            }
                            try {
                                try {
                                    buf.append("uid=").append(this.stat.uid());
                                }
                                catch (Exception e) {
                                    Object var10_23 = null;
                                    buf.append(", ");
                                    break block35;
                                }
                                Object var10_22 = null;
                                buf.append(", ");
                            }
                            catch (Throwable throwable) {
                                Object var10_24 = null;
                                buf.append(", ");
                                throw throwable;
                            }
                        }
                        try {
                            try {
                                buf.append("gid=").append(this.stat.gid());
                            }
                            catch (Exception e) {
                                Object var12_27 = null;
                                buf.append(", ");
                                break block36;
                            }
                            Object var12_26 = null;
                            buf.append(", ");
                        }
                        catch (Throwable throwable) {
                            Object var12_28 = null;
                            buf.append(", ");
                            throw throwable;
                        }
                    }
                    try {
                        try {
                            buf.append("rdev=0x").append(Long.toHexString(this.stat.rdev()));
                        }
                        catch (Exception e) {
                            Object var14_31 = null;
                            buf.append(", ");
                            break block37;
                        }
                        Object var14_30 = null;
                        buf.append(", ");
                    }
                    catch (Throwable throwable) {
                        Object var14_32 = null;
                        buf.append(", ");
                        throw throwable;
                    }
                }
                buf.append("size=").append(this.sizeInternal()).append(", ");
                try {
                    try {
                        buf.append("blksize=").append(this.stat.blockSize());
                    }
                    catch (Exception e) {
                        Object var16_35 = null;
                        buf.append(", ");
                        break block38;
                    }
                    Object var16_34 = null;
                    buf.append(", ");
                }
                catch (Throwable throwable) {
                    Object var16_36 = null;
                    buf.append(", ");
                    throw throwable;
                }
            }
            try {
                try {
                    buf.append("blocks=").append(this.stat.blocks());
                }
                catch (Exception exception2) {
                    Object var18_39 = null;
                    buf.append(", ");
                    break block39;
                }
                Object var18_38 = null;
                buf.append(", ");
            }
            catch (Throwable throwable) {
                Object var18_40 = null;
                buf.append(", ");
                throw throwable;
            }
        }
        buf.append("atime=").append(this.atime()).append(", ");
        buf.append("mtime=").append(this.mtime()).append(", ");
        buf.append("ctime=").append(this.ctime());
        buf.append(">");
        return this.getRuntime().newString(buf.toString());
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid() {
        return this.getRuntime().newFixnum(this.stat.uid());
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode() {
        return this.getRuntime().newFixnum(this.stat.mode());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        return this.getRuntime().newTime(this.stat.mtime() * 1000L);
    }

    public IRubyObject mtimeEquals(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() == RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeGreaterThan(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() > RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeLessThan(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() < RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    @JRubyMethod(name={"nlink"})
    public IRubyObject nlink() {
        return this.getRuntime().newFixnum(this.stat.nlink());
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p() {
        return this.getRuntime().newBoolean(this.stat.isOwned());
    }

    @JRubyMethod(name={"pipe?"})
    public IRubyObject pipe_p() {
        return this.getRuntime().newBoolean(this.stat.isNamedPipe());
    }

    @JRubyMethod(name={"rdev"})
    public IRubyObject rdev() {
        return this.getRuntime().newFixnum(this.stat.rdev());
    }

    @JRubyMethod(name={"rdev_major"})
    public IRubyObject rdevMajor() {
        return this.getRuntime().newFixnum(this.stat.major(this.stat.rdev()));
    }

    @JRubyMethod(name={"rdev_minor"})
    public IRubyObject rdevMinor() {
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.rdev()));
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p() {
        return this.getRuntime().newBoolean(this.stat.isReadable());
    }

    @JRubyMethod(name={"readable_real?"})
    public IRubyObject readableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isReadableReal());
    }

    @JRubyMethod(name={"setgid?"})
    public IRubyObject setgid_p() {
        return this.getRuntime().newBoolean(this.stat.isSetgid());
    }

    @JRubyMethod(name={"setuid?"})
    public IRubyObject setuid_p() {
        return this.getRuntime().newBoolean(this.stat.isSetuid());
    }

    private long sizeInternal() {
        if (Platform.IS_WINDOWS && this.file != null) {
            try {
                return this.file.length();
            }
            catch (SecurityException ex) {
                return 0L;
            }
        }
        return this.stat.st_size();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.sizeInternal());
    }

    @JRubyMethod(name={"size?"})
    public IRubyObject size_p() {
        long size2 = this.sizeInternal();
        if (size2 == 0L) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(size2);
    }

    @JRubyMethod(name={"socket?"})
    public IRubyObject socket_p() {
        return this.getRuntime().newBoolean(this.stat.isSocket());
    }

    @JRubyMethod(name={"sticky?"})
    public IRubyObject sticky_p() {
        return this.getRuntime().newBoolean(this.stat.isSticky());
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p() {
        return this.getRuntime().newBoolean(this.stat.isSymlink());
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p() {
        return this.getRuntime().newBoolean(this.stat.isWritable());
    }

    @JRubyMethod(name={"writable_real?"})
    public IRubyObject writableReal_p() {
        return this.getRuntime().newBoolean(this.stat.isWritableReal());
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.stat.isEmpty());
    }

    @JRubyMethod(name={"world_readable?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject worldReadable(ThreadContext context) {
        return this.getWorldMode(context, 4);
    }

    @JRubyMethod(name={"world_writable?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject worldWritable(ThreadContext context) {
        return this.getWorldMode(context, 2);
    }

    private IRubyObject getWorldMode(ThreadContext context, int mode2) {
        if ((this.stat.mode() & mode2) == mode2) {
            return RubyNumeric.int2fix(context.getRuntime(), this.stat.mode() & 0x1FF);
        }
        return context.getRuntime().getNil();
    }

    public static class ZipFileStat
    implements FileStat {
        private final ZipEntry zipEntry;

        public ZipFileStat(ZipEntry zipEntry) {
            this.zipEntry = zipEntry;
        }

        public long atime() {
            return this.zipEntry.getTime();
        }

        public long blocks() {
            return this.zipEntry.getSize();
        }

        public long blockSize() {
            return 1L;
        }

        public long ctime() {
            return this.zipEntry.getTime();
        }

        public long dev() {
            return -1L;
        }

        public String ftype() {
            return "zip file entry";
        }

        public int gid() {
            return -1;
        }

        public boolean groupMember(int i2) {
            return false;
        }

        public long ino() {
            return -1L;
        }

        public boolean isBlockDev() {
            return false;
        }

        public boolean isCharDev() {
            return false;
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public boolean isEmpty() {
            return this.zipEntry.getSize() == 0L;
        }

        public boolean isExecutable() {
            return false;
        }

        public boolean isExecutableReal() {
            return false;
        }

        public boolean isFifo() {
            return false;
        }

        public boolean isFile() {
            return !this.zipEntry.isDirectory();
        }

        public boolean isGroupOwned() {
            return false;
        }

        public boolean isIdentical(FileStat fs) {
            return fs instanceof ZipFileStat && ((ZipFileStat)fs).zipEntry.equals(this.zipEntry);
        }

        public boolean isNamedPipe() {
            return false;
        }

        public boolean isOwned() {
            return false;
        }

        public boolean isROwned() {
            return false;
        }

        public boolean isReadable() {
            return true;
        }

        public boolean isReadableReal() {
            return true;
        }

        public boolean isWritable() {
            return false;
        }

        public boolean isWritableReal() {
            return false;
        }

        public boolean isSetgid() {
            return false;
        }

        public boolean isSetuid() {
            return false;
        }

        public boolean isSocket() {
            return false;
        }

        public boolean isSticky() {
            return false;
        }

        public boolean isSymlink() {
            return false;
        }

        public int major(long l) {
            return -1;
        }

        public int minor(long l) {
            return -1;
        }

        public int mode() {
            return -1;
        }

        public long mtime() {
            return this.zipEntry.getTime();
        }

        public int nlink() {
            return -1;
        }

        public long rdev() {
            return -1L;
        }

        public long st_size() {
            return this.zipEntry.getSize();
        }

        public int uid() {
            return 0;
        }
    }
}

