/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl;

import com.kenai.jaffl.annotations.Direct;
import com.kenai.jaffl.annotations.In;
import com.kenai.jaffl.annotations.NulTerminate;
import com.kenai.jaffl.annotations.Out;
import com.kenai.jaffl.annotations.Pinned;
import com.kenai.jaffl.annotations.Transient;
import java.lang.annotation.Annotation;

public final class ParameterFlags {
    public static final int OUT = 1;
    public static final int IN = 2;
    public static final int PINNED = 4;
    public static final int NULTERMINATE = 8;
    public static final int TRANSIENT = 16;
    public static final int DIRECT = 32;

    private ParameterFlags() {
    }

    public static final int parse(Annotation[] annotations2) {
        int flags = 0;
        for (Annotation a : annotations2) {
            flags |= a instanceof Out ? 1 : 0;
            flags |= a instanceof In ? 2 : 0;
            flags |= a instanceof Transient ? 16 : 0;
            flags |= a instanceof Direct ? 32 : 0;
            flags |= a instanceof Pinned ? 4 : 0;
            flags |= a instanceof NulTerminate ? 8 : 0;
        }
        return flags;
    }

    public static final boolean isFlag(Annotation annotation2) {
        return annotation2 instanceof Pinned || annotation2 instanceof Transient || annotation2 instanceof Direct || annotation2 instanceof NulTerminate || annotation2 instanceof Out || annotation2 instanceof In;
    }

    public static final boolean isPinned(int flags) {
        return (flags & 4) != 0;
    }

    public static final boolean isTransient(int flags) {
        return (flags & 0x10) != 0;
    }

    public static final boolean isDirect(int flags) {
        return (flags & 0x20) != 0;
    }

    public static final boolean isNulTerminate(int flags) {
        return (flags & 8) != 0;
    }

    public static final boolean isOut(int flags) {
        return (flags & 3) != 2;
    }

    public static final boolean isIn(int flags) {
        return (flags & 3) != 1;
    }
}

