/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.rmi.server.security;

import java.rmi.RemoteException;
import java.security.Principal;
import javax.jcr.RepositoryException;
import javax.jcr.security.AccessControlEntry;
import javax.jcr.security.AccessControlList;
import javax.jcr.security.AccessControlManager;
import javax.jcr.security.AccessControlPolicy;
import javax.jcr.security.Privilege;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlEntry;
import org.apache.jackrabbit.rmi.remote.security.RemoteAccessControlList;
import org.apache.jackrabbit.rmi.server.RemoteAdapterFactory;
import org.apache.jackrabbit.rmi.server.security.ServerAccessControlEntry;
import org.apache.jackrabbit.rmi.server.security.ServerAccessControlPolicy;

public class ServerAccessControlList
extends ServerAccessControlPolicy
implements RemoteAccessControlList {
    protected AccessControlManager accessControlManager;

    public ServerAccessControlList(AccessControlManager accessControlManager, AccessControlList acl, RemoteAdapterFactory factory) throws RemoteException {
        super((AccessControlPolicy)acl, factory);
        this.accessControlManager = accessControlManager;
    }

    public RemoteAccessControlEntry[] getAccessControlEntries() throws RepositoryException, RemoteException {
        return this.getFactory().getRemoteAccessControlEntry(((AccessControlList)this.getAccessControlPolicy()).getAccessControlEntries());
    }

    public boolean addAccessControlEntry(final String principalName, String[] privilegesNames) throws RepositoryException, RemoteException {
        Principal principal = new Principal(){

            public String getName() {
                return principalName;
            }
        };
        Privilege[] privileges = new Privilege[privilegesNames.length];
        int i = 0;
        while (i < privilegesNames.length) {
            String privilegeName = privilegesNames[i];
            privileges[i] = this.accessControlManager.privilegeFromName(privilegeName);
            ++i;
        }
        return ((AccessControlList)this.getAccessControlPolicy()).addAccessControlEntry(principal, privileges);
    }

    public void removeAccessControlEntry(RemoteAccessControlEntry ace) throws RepositoryException {
        if (!(ace instanceof ServerAccessControlEntry)) {
            throw new RepositoryException("Unsupported RemoteAccessControlEntry type " + ace.getClass());
        }
        AccessControlEntry lace = ((ServerAccessControlEntry)ace).getAccessControlEntry();
        ((AccessControlList)this.getAccessControlPolicy()).removeAccessControlEntry(lace);
    }

    public void setPolicy(String absPath) throws RepositoryException, RemoteException {
        this.accessControlManager.setPolicy(absPath, this.getAccessControlPolicy());
    }
}

