/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.error;

import org.hsqldb.HsqlException;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.resources.BundleHandler;
import org.hsqldb.result.Result;

public class Error {
    public static boolean TRACE = false;
    public static boolean TRACESYSTEMOUT = false;
    private static final String errPropsName = "sql-state-messages";
    private static final int bundleHandle = BundleHandler.getBundleHandle("sql-state-messages", null);
    private static final String MESSAGE_TAG = "$$";
    private static final int SQL_STATE_DIGITS = 5;
    private static final int SQL_CODE_DIGITS = 4;
    private static final int ERROR_CODE_BASE = 11;

    public static RuntimeException runtimeError(int code, String add) {
        HsqlException e = Error.error(code, add);
        return new RuntimeException(e.getMessage());
    }

    public static HsqlException error(int code, String add) {
        return Error.error((Throwable)null, code, add);
    }

    public static HsqlException error(Throwable t, int code, String add) {
        String s = Error.getMessage(code);
        if (add != null) {
            s = s + ": " + add.toString();
        }
        return new HsqlException(t, s.substring(6), s.substring(0, 5), -code);
    }

    public static HsqlException parseError(int code, String add, int lineNumber) {
        String s = Error.getMessage(code);
        if (add != null) {
            s = s + ": " + add;
        }
        if (lineNumber > 1) {
            add = Error.getMessage(24);
            s = s + " :" + add + String.valueOf(lineNumber);
        }
        return new HsqlException(null, s.substring(6), s.substring(0, 5), -code);
    }

    public static HsqlException error(int code) {
        return Error.error(null, code, 0, null);
    }

    public static HsqlException error(int code, Throwable t) {
        String message = Error.getMessage(code, 0, null);
        return new HsqlException(t, message.substring(0, 5), -code);
    }

    public static HsqlException error(Throwable t, int code, int subCode, Object[] add) {
        String message = Error.getMessage(code, subCode, add);
        int sqlCode = subCode < 11 ? code : subCode;
        return new HsqlException(t, message.substring(6), message.substring(0, 5), -sqlCode);
    }

    public static HsqlException parseError(int code, int subCode, int lineNumber, Object[] add) {
        String message = Error.getMessage(code, subCode, add);
        if (lineNumber > 1) {
            String sub = Error.getMessage(24);
            message = message + " :" + sub + String.valueOf(lineNumber);
        }
        int sqlCode = subCode < 11 ? code : subCode;
        return new HsqlException(null, message.substring(6), message.substring(0, 5), -sqlCode);
    }

    public static HsqlException error(int code, int code2) {
        return Error.error(code, Error.getMessage(code2));
    }

    public static HsqlException error(String message, String sqlState, int i) {
        return new HsqlException(null, message, sqlState, i);
    }

    private static String insertStrings(String message, Object[] add) {
        StringBuffer sb = new StringBuffer(message.length() + 32);
        int lastIndex = 0;
        int escIndex = message.length();
        for (int i = 0; i < add.length && (escIndex = message.indexOf(MESSAGE_TAG, lastIndex)) != -1; ++i) {
            sb.append(message.substring(lastIndex, escIndex));
            sb.append(add[i] == null ? "null exception message" : add[i].toString());
            lastIndex = escIndex + MESSAGE_TAG.length();
        }
        escIndex = message.length();
        sb.append(message.substring(lastIndex, escIndex));
        return sb.toString();
    }

    public static String getMessage(int errorCode) {
        return Error.getResourceString(errorCode);
    }

    public static String getStateString(int errorCode) {
        return Error.getMessage(errorCode, 0, null).substring(0, 5);
    }

    public static String getMessage(int code, int subCode, Object[] add) {
        String message = Error.getResourceString(code);
        if (subCode != 0) {
            message = message + Error.getResourceString(subCode);
        }
        if (add != null) {
            message = Error.insertStrings(message, add);
        }
        return message;
    }

    private static String getResourceString(int code) {
        String key = StringUtil.toZeroPaddedString(code, 4, 4);
        return BundleHandler.getString(bundleHandle, key);
    }

    public static HsqlException error(Result result) {
        return new HsqlException(result);
    }

    public static void printSystemOut(String message) {
        if (TRACESYSTEMOUT) {
            System.out.println(message);
        }
    }
}

