/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

public class NetRoute
implements Serializable {
    private static final long serialVersionUID = 13039L;
    String destination = null;
    String gateway = null;
    long flags = 0L;
    long refcnt = 0L;
    long use = 0L;
    long metric = 0L;
    String mask = null;
    long mtu = 0L;
    long window = 0L;
    long irtt = 0L;
    String ifname = null;

    public native void gather(Sigar var1) throws SigarException;

    static NetRoute fetch(Sigar sigar) throws SigarException {
        NetRoute netRoute = new NetRoute();
        netRoute.gather(sigar);
        return netRoute;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getGateway() {
        return this.gateway;
    }

    public long getFlags() {
        return this.flags;
    }

    public long getRefcnt() {
        return this.refcnt;
    }

    public long getUse() {
        return this.use;
    }

    public long getMetric() {
        return this.metric;
    }

    public String getMask() {
        return this.mask;
    }

    public long getMtu() {
        return this.mtu;
    }

    public long getWindow() {
        return this.window;
    }

    public long getIrtt() {
        return this.irtt;
    }

    public String getIfname() {
        return this.ifname;
    }

    void copyTo(NetRoute copy) {
        copy.destination = this.destination;
        copy.gateway = this.gateway;
        copy.flags = this.flags;
        copy.refcnt = this.refcnt;
        copy.use = this.use;
        copy.metric = this.metric;
        copy.mask = this.mask;
        copy.mtu = this.mtu;
        copy.window = this.window;
        copy.irtt = this.irtt;
        copy.ifname = this.ifname;
    }

    public Map toMap() {
        String strifname;
        String strirtt;
        String strwindow;
        String strmtu;
        String strmask;
        String strmetric;
        String struse;
        String strrefcnt;
        String strflags;
        String strgateway;
        HashMap<String, String> map = new HashMap<String, String>();
        String strdestination = String.valueOf(this.destination);
        if (!"-1".equals(strdestination)) {
            map.put("Destination", strdestination);
        }
        if (!"-1".equals(strgateway = String.valueOf(this.gateway))) {
            map.put("Gateway", strgateway);
        }
        if (!"-1".equals(strflags = String.valueOf(this.flags))) {
            map.put("Flags", strflags);
        }
        if (!"-1".equals(strrefcnt = String.valueOf(this.refcnt))) {
            map.put("Refcnt", strrefcnt);
        }
        if (!"-1".equals(struse = String.valueOf(this.use))) {
            map.put("Use", struse);
        }
        if (!"-1".equals(strmetric = String.valueOf(this.metric))) {
            map.put("Metric", strmetric);
        }
        if (!"-1".equals(strmask = String.valueOf(this.mask))) {
            map.put("Mask", strmask);
        }
        if (!"-1".equals(strmtu = String.valueOf(this.mtu))) {
            map.put("Mtu", strmtu);
        }
        if (!"-1".equals(strwindow = String.valueOf(this.window))) {
            map.put("Window", strwindow);
        }
        if (!"-1".equals(strirtt = String.valueOf(this.irtt))) {
            map.put("Irtt", strirtt);
        }
        if (!"-1".equals(strifname = String.valueOf(this.ifname))) {
            map.put("Ifname", strifname);
        }
        return map;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

