/*
 * Decompiled with CFR 0.152.
 */
package gr.uoa.di.madgik.commons.infra.nodeselection.ru;

import gr.uoa.di.madgik.commons.infra.HostingNode;
import gr.uoa.di.madgik.commons.infra.nodeselection.HostingNodeInfo;
import gr.uoa.di.madgik.commons.infra.nodeselection.NodeSelector;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class RUNodeSelector
implements NodeSelector {
    protected static Map<String, Long> timingInfo = new ConcurrentHashMap<String, Long>();
    protected NodeSelector tieBreakerSelector = null;

    public RUNodeSelector() {
    }

    public RUNodeSelector(NodeSelector tieBreaker) {
        this.tieBreakerSelector = tieBreaker;
    }

    @Override
    public HostingNode selectNode(List<HostingNode> candidates) {
        ArrayList<HostingNode> leftOver = new ArrayList<HostingNode>();
        boolean firstRound = false;
        if (this.tieBreakerSelector != null) {
            for (HostingNode c : candidates) {
                if (timingInfo.containsKey(c.getId())) continue;
                firstRound = true;
                leftOver.add(c);
            }
        }
        HostingNode RUNode = null;
        if (candidates.isEmpty()) {
            return null;
        }
        RUNode = firstRound ? this.tieBreakerSelector.selectNode(leftOver) : this.getRUNode(candidates);
        timingInfo.put(RUNode.getId(), System.nanoTime());
        return RUNode;
    }

    public abstract HostingNode getRUNode(List<HostingNode> var1);

    public abstract Map<String, Long> sortTimingInfo();

    /*
     * WARNING - void declaration
     */
    @Override
    public List<HostingNodeInfo> assessNodes(List<HostingNode> candidates) {
        ArrayList<HostingNodeInfo> assessedNodes;
        block12: {
            HashMap<String, HostingNode> hnIndex;
            Map<String, Long> sortedTimingInfo;
            block10: {
                ArrayList<HostingNode> unselectedNodes;
                block11: {
                    sortedTimingInfo = this.sortTimingInfo();
                    sortedTimingInfo.putAll(timingInfo);
                    Float firstRoundMinScore = Float.valueOf(Float.MAX_VALUE);
                    assessedNodes = new ArrayList<HostingNodeInfo>();
                    unselectedNodes = new ArrayList<HostingNode>();
                    List<HostingNodeInfo> firstRoundAssessed = null;
                    int foundUnselected = 0;
                    for (HostingNode hostingNode : candidates) {
                        if (timingInfo.containsKey(hostingNode.getId())) continue;
                        if (firstRoundAssessed == null && this.tieBreakerSelector != null) {
                            firstRoundAssessed = this.tieBreakerSelector.assessNodes(candidates);
                            firstRoundMinScore = firstRoundAssessed.get((int)(firstRoundAssessed.size() - 1)).score;
                        }
                        ++foundUnselected;
                        unselectedNodes.add(hostingNode);
                    }
                    hnIndex = new HashMap<String, HostingNode>();
                    for (HostingNode hostingNode : candidates) {
                        hnIndex.put(hostingNode.getId(), hostingNode);
                    }
                    if (foundUnselected <= 0) break block10;
                    if (this.tieBreakerSelector == null) break block11;
                    for (HostingNodeInfo hostingNodeInfo : firstRoundAssessed) {
                        if (timingInfo.containsKey(hostingNodeInfo.node.getId())) continue;
                        assessedNodes.add(new HostingNodeInfo(hostingNodeInfo.node, hostingNodeInfo.score));
                    }
                    if ((double)Math.abs(((HostingNodeInfo)assessedNodes.get((int)0)).score.floatValue() - 1.0f) > 1.0E-10) {
                        float f = 1.0f / ((HostingNodeInfo)assessedNodes.get((int)0)).score.floatValue();
                        Iterator iterator = assessedNodes.iterator();
                        while (iterator.hasNext()) {
                            HostingNodeInfo hostingNodeInfo;
                            HostingNodeInfo hostingNodeInfo2 = hostingNodeInfo = (HostingNodeInfo)iterator.next();
                            Float.valueOf(hostingNodeInfo2.score.floatValue() * f);
                            hostingNodeInfo2.score = hostingNodeInfo2.score;
                        }
                        firstRoundMinScore = Float.valueOf(firstRoundMinScore.floatValue() * f);
                    }
                    if (foundUnselected >= candidates.size()) break block12;
                    boolean bl = false;
                    float f = firstRoundMinScore.floatValue() / (float)(candidates.size() - foundUnselected + 1);
                    for (String hnId : sortedTimingInfo.keySet()) {
                        void var9_14;
                        HostingNode hn = (HostingNode)hnIndex.get(hnId);
                        if (hn == null) continue;
                        assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(firstRoundMinScore.floatValue() - (float)(++var9_14) * f)));
                    }
                    break block12;
                }
                for (HostingNode hostingNode : unselectedNodes) {
                    assessedNodes.add(new HostingNodeInfo(hostingNode, Float.valueOf(1.0f)));
                }
                boolean bl = true;
                for (String string : sortedTimingInfo.keySet()) {
                    void var9_17;
                    HostingNode hn = (HostingNode)hnIndex.get(string);
                    if (hn == null) continue;
                    assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(1.0f - (float)(++var9_17) * (1.0f / (float)candidates.size()))));
                }
                break block12;
            }
            boolean bl = false;
            for (String string : sortedTimingInfo.keySet()) {
                void var9_19;
                HostingNode hn = (HostingNode)hnIndex.get(string);
                if (hn == null) continue;
                assessedNodes.add(new HostingNodeInfo(hn, Float.valueOf(1.0f - (float)(++var9_19) * (1.0f / (float)candidates.size()))));
            }
        }
        return assessedNodes;
    }

    @Override
    public void markSelected(HostingNode node) {
        timingInfo.put(node.getId(), System.nanoTime());
    }

    public static void main(String[] args) {
    }
}

