/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax;

import com.google.common.collect.Maps;
import com.netflix.astyanax.Keyspace;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.MutationBatchManager;
import com.netflix.astyanax.connectionpool.exceptions.ConnectionException;
import com.netflix.astyanax.model.ConsistencyLevel;
import java.util.LinkedHashMap;
import java.util.Map;

public class MultiMutationBatchManager
implements MutationBatchManager {
    private final String DEFAULT_BATCH_NAME = "default";
    private final ThreadLocal<Map<String, MutationBatch>> batches = new ThreadLocal();
    private final Keyspace keyspace;
    private final ConsistencyLevel cl;

    public MultiMutationBatchManager(Keyspace keyspace, ConsistencyLevel cl) {
        this.keyspace = keyspace;
        this.cl = cl;
    }

    @Override
    public MutationBatch getSharedMutationBatch() {
        return this.getNamedMutationBatch("default");
    }

    public MutationBatch getNamedMutationBatch(String name) {
        MutationBatch mb;
        LinkedHashMap mbs = this.batches.get();
        if (mbs == null) {
            mbs = Maps.newLinkedHashMap();
            this.batches.set(mbs);
        }
        if ((mb = (MutationBatch)mbs.get(name)) == null) {
            mb = this.getNewMutationBatch();
            mbs.put(name, mb);
        }
        return mb;
    }

    @Override
    public void commitSharedMutationBatch() throws ConnectionException {
        Map<String, MutationBatch> mbs = this.batches.get();
        if (mbs != null) {
            for (Map.Entry<String, MutationBatch> entry : mbs.entrySet()) {
                entry.getValue().execute();
            }
            this.batches.remove();
        }
    }

    @Override
    public void discard() {
        this.batches.remove();
    }

    @Override
    public MutationBatch getNewMutationBatch() {
        return this.keyspace.prepareMutationBatch().setConsistencyLevel(this.cl);
    }
}

