/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.id.PropertyId;
import org.apache.jackrabbit.core.state.ChildNodeEntry;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.spi.Name;

class NodeStateMerger {
    NodeStateMerger() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean merge(NodeState state, MergeContext context) {
        NodeState overlayedState = (NodeState)state.getOverlayedState();
        if (overlayedState == null || state.getModCount() == overlayedState.getModCount()) {
            return false;
        }
        NodeState nodeState = overlayedState;
        synchronized (nodeState) {
            NodeState nodeState2 = state;
            synchronized (nodeState2) {
                AbstractCollection removed;
                AbstractCollection added;
                if (!state.getReorderedChildNodeEntries().isEmpty()) {
                    return false;
                }
                if (!((Object)state.getMixinTypeNames()).equals(overlayedState.getMixinTypeNames())) {
                    return false;
                }
                if (state.getParentId() != null && !state.getParentId().equals(overlayedState.getParentId())) {
                    return false;
                }
                if (!((Object)state.getChildNodeEntries()).equals(overlayedState.getChildNodeEntries())) {
                    added = new ArrayList();
                    removed = new ArrayList();
                    for (ChildNodeEntry cne : state.getAddedChildNodeEntries()) {
                        if (!context.isAdded(cne.getId()) && !context.isModified(cne.getId())) continue;
                        if (overlayedState.hasChildNodeEntry(cne.getName()) && cne.getIndex() < 2 && !context.allowsSameNameSiblings(cne.getId())) {
                            return false;
                        }
                        ((ArrayList)added).add(cne);
                    }
                    for (ChildNodeEntry cne : state.getRemovedChildNodeEntries()) {
                        if (!context.isDeleted(cne.getId()) && !context.isModified(cne.getId())) continue;
                        ((ArrayList)removed).add(cne);
                    }
                    state.setChildNodeEntries(overlayedState.getChildNodeEntries());
                    for (ChildNodeEntry cne : added) {
                        state.addChildNodeEntry(cne.getName(), cne.getId());
                    }
                    for (ChildNodeEntry cne : removed) {
                        state.removeChildNodeEntry(cne.getId());
                    }
                }
                if (!((Object)state.getPropertyNames()).equals(overlayedState.getPropertyNames())) {
                    PropertyId propId;
                    added = new HashSet();
                    removed = new HashSet();
                    for (Name name : state.getAddedPropertyNames()) {
                        propId = new PropertyId(state.getNodeId(), name);
                        if (!context.isAdded(propId)) continue;
                        ((HashSet)added).add(name);
                    }
                    for (Name name : state.getRemovedPropertyNames()) {
                        propId = new PropertyId(state.getNodeId(), name);
                        if (!context.isDeleted(propId)) continue;
                        ((HashSet)removed).add(name);
                    }
                    state.setPropertyNames(overlayedState.getPropertyNames());
                    for (Name name : added) {
                        state.addPropertyName(name);
                    }
                    for (Name name : removed) {
                        state.removePropertyName(name);
                    }
                }
                state.setModCount(overlayedState.getModCount());
                return true;
            }
        }
    }

    static interface MergeContext {
        public boolean isAdded(ItemId var1);

        public boolean isDeleted(ItemId var1);

        public boolean isModified(ItemId var1);

        public boolean allowsSameNameSiblings(NodeId var1);
    }
}

