/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm.record;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.record.DomToXMLStreamWriter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.record.MarshalRecord;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XMLStreamWriterRecord
extends MarshalRecord {
    private static int COUNTER = 0;
    private DomToXMLStreamWriter domToStreamWriter;
    private Map<String, String> prefixMapping;
    private NamespaceResolver namespaceResolver;
    private XMLStreamWriter xmlStreamWriter;

    public XMLStreamWriterRecord(XMLStreamWriter xmlStreamWriter) {
        this.xmlStreamWriter = xmlStreamWriter;
    }

    public XMLStreamWriter getXMLStreamWriter() {
        return this.xmlStreamWriter;
    }

    public void setXMLStreamWriter(XMLStreamWriter anXMLStreamWriter) {
        this.xmlStreamWriter = anXMLStreamWriter;
    }

    private DomToXMLStreamWriter getDomToXMLStreamWriter() {
        if (null == this.domToStreamWriter) {
            this.domToStreamWriter = new DomToXMLStreamWriter();
        }
        return this.domToStreamWriter;
    }

    public void attribute(XPathFragment xPathFragment, NamespaceResolver namespaceResolver, String value) {
        try {
            String namespaceURI = xPathFragment.getNamespaceURI();
            if (namespaceURI == null) {
                this.xmlStreamWriter.writeAttribute(xPathFragment.getLocalName(), value);
            } else {
                String prefix = xPathFragment.getPrefix();
                if (prefix == null) {
                    this.xmlStreamWriter.writeAttribute(namespaceURI, xPathFragment.getLocalName(), value);
                } else {
                    this.xmlStreamWriter.writeAttribute(prefix, namespaceURI, xPathFragment.getLocalName(), value);
                }
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void attribute(String namespaceURI, String localName, String name, String value) {
        try {
            if (namespaceURI != null && namespaceURI.equals("http://www.w3.org/2000/xmlns/")) {
                if (localName.equals("xmlns")) {
                    this.xmlStreamWriter.writeDefaultNamespace(value);
                } else {
                    this.xmlStreamWriter.writeNamespace(localName, value);
                }
            } else {
                NamespaceContext ctx = this.xmlStreamWriter.getNamespaceContext();
                if (namespaceURI == null || namespaceURI.length() == 0) {
                    this.xmlStreamWriter.writeAttribute(localName, value);
                } else {
                    this.xmlStreamWriter.writeAttribute(this.xmlStreamWriter.getNamespaceContext().getPrefix(namespaceURI), namespaceURI, localName, value);
                }
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void cdata(String value) {
        try {
            this.xmlStreamWriter.writeCData(value);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void characters(String value) {
        try {
            this.xmlStreamWriter.writeCharacters(value);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void closeStartElement() {
    }

    public void openStartElement(XPathFragment xPathFragment, NamespaceResolver namespaceResolver) {
        super.openStartElement(xPathFragment, namespaceResolver);
        try {
            String namespaceURI = xPathFragment.getNamespaceURI();
            if (namespaceURI == null) {
                this.xmlStreamWriter.writeStartElement("", xPathFragment.getLocalName(), "");
                String defaultNamespace = this.xmlStreamWriter.getNamespaceContext().getNamespaceURI("");
                if (defaultNamespace != null && defaultNamespace.length() > 0) {
                    this.xmlStreamWriter.writeDefaultNamespace("");
                }
            } else {
                String prefix = xPathFragment.getPrefix();
                if (prefix == null) {
                    prefix = "";
                }
                this.xmlStreamWriter.writeStartElement(prefix, xPathFragment.getLocalName(), namespaceURI);
            }
            this.writePrefixMappings();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void element(XPathFragment frag) {
        try {
            this.xmlStreamWriter.writeStartElement(frag.getShortName());
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endDocument() {
        try {
            this.xmlStreamWriter.writeEndDocument();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void endElement(XPathFragment pathFragment, NamespaceResolver namespaceResolver) {
        try {
            this.xmlStreamWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void node(Node node, NamespaceResolver resolver) {
        try {
            if (node.getNodeType() == 9) {
                node = ((Document)node).getDocumentElement();
            }
            this.getDomToXMLStreamWriter().writeToStream(node, this.xmlStreamWriter);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startDocument(String encoding, String version) {
        try {
            this.xmlStreamWriter.writeStartDocument(encoding, version);
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceUri) {
        if (null == this.prefixMapping) {
            this.prefixMapping = new HashMap<String, String>();
        }
        this.prefixMapping.put(prefix, namespaceUri);
    }

    private void writePrefixMappings() {
        try {
            if (null != this.namespaceResolver) {
                String defaultNamespace = this.namespaceResolver.getDefaultNamespaceURI();
                if (defaultNamespace != null) {
                    this.xmlStreamWriter.writeNamespace("", defaultNamespace);
                }
                for (Map.Entry<String, String> entry : this.namespaceResolver.getPrefixesToNamespaces().entrySet()) {
                    this.xmlStreamWriter.writeNamespace(entry.getKey(), entry.getValue());
                }
                this.namespaceResolver = null;
            }
            if (null != this.prefixMapping) {
                for (Map.Entry<String, String> entry : this.prefixMapping.entrySet()) {
                    this.xmlStreamWriter.writeNamespace(entry.getKey(), entry.getValue());
                }
                this.prefixMapping = null;
            }
        }
        catch (XMLStreamException e) {
            throw XMLMarshalException.marshalException(e);
        }
    }

    public void namespaceDeclarations(NamespaceResolver namespaceResolver) {
    }

    public void startPrefixMappings(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }
}

