/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.servlet.filters.dynamiccss;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.ClassLoaderUtil;
import com.liferay.portal.util.PropsValues;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RTLCSSUtil {
    private static Log _log = LogFactoryUtil.getLog(RTLCSSUtil.class);
    private static Pattern[] _RTL_CSS_EXCLUDED_PATHS_PATTERNS;
    private static String _jsScript;

    static {
        String[] rtlCssExcludedPathsRegexp = PropsValues.RTL_CSS_EXCLUDED_PATHS_REGEXP;
        _RTL_CSS_EXCLUDED_PATHS_PATTERNS = new Pattern[rtlCssExcludedPathsRegexp.length];
        int i2 = 0;
        while (i2 < rtlCssExcludedPathsRegexp.length) {
            RTLCSSUtil._RTL_CSS_EXCLUDED_PATHS_PATTERNS[i2] = Pattern.compile(rtlCssExcludedPathsRegexp[i2]);
            ++i2;
        }
    }

    public static String getRtlCss(String fileName, String css) throws Exception {
        Context context = Context.enter();
        String rtlCss = css;
        try {
            try {
                ScriptableObject scope = context.initStandardObjects();
                context.evaluateString((Scriptable)scope, _jsScript, "script", 1, null);
                Function function = (Function)scope.get("r2", (Scriptable)scope);
                Object result = function.call(context, (Scriptable)scope, (Scriptable)scope, new Object[]{css});
                rtlCss = (String)Context.jsToJava((Object)result, String.class);
            }
            catch (Exception exception) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to parse " + fileName + " to RTL"));
                }
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
        return rtlCss;
    }

    public static void init() {
        try {
            _jsScript = StringUtil.read((ClassLoader)ClassLoaderUtil.getPortalClassLoader(), (String)"com/liferay/portal/servlet/filters/dynamiccss/dependencies/r2.js");
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
    }

    public static boolean isExcludedPath(String filePath) {
        Pattern[] patternArray = _RTL_CSS_EXCLUDED_PATHS_PATTERNS;
        int n = _RTL_CSS_EXCLUDED_PATHS_PATTERNS.length;
        int n2 = 0;
        while (n2 < n) {
            Pattern pattern = patternArray[n2];
            Matcher matcher = pattern.matcher(filePath);
            if (matcher.matches()) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

